/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.io.IOException;
import java.io.OutputStream;
import org.rapidoid.RapidoidThing;

public class StreamUtils
extends RapidoidThing {
    private static final String MIN_VALUE = "-9223372036854775808";

    public static void putNumAsText(OutputStream out, long n) throws IOException {
        if (n >= 0L) {
            StreamUtils.writeDigits(out, n);
        } else if (n == Long.MIN_VALUE) {
            StreamUtils.writeAscii(out, MIN_VALUE);
        } else {
            out.write(45);
            StreamUtils.putNumAsText(out, -n);
        }
    }

    private static void writeDigits(OutputStream out, long n) throws IOException {
        int digit = (int)(n % 10L);
        if (n >= 10L) {
            StreamUtils.writeDigits(out, n / 10L);
        }
        out.write(digit + 48);
    }

    public static void writeAscii(OutputStream out, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            out.write(s.charAt(i));
        }
    }

    public static void writeUTF8(OutputStream out, String src) throws IOException {
        int limit = src.length();
        for (int i = 0; i < limit; ++i) {
            char c = src.charAt(i);
            if (c < '\u0080') {
                out.write(c);
                continue;
            }
            if (c < '\u0800') {
                out.write(0xC0 | c >> 6);
                out.write(0x80 | c & 0x3F);
                continue;
            }
            if (Character.isSurrogate(c)) {
                if (Character.isHighSurrogate(c)) {
                    int next = i + 1;
                    if (next < limit) {
                        char nextChar = src.charAt(next);
                        if (Character.isLowSurrogate(nextChar)) {
                            int cp = Character.toCodePoint(c, nextChar);
                            out.write(0xF0 | cp >> 18);
                            out.write(0x80 | cp >> 12 & 0x3F);
                            out.write(0x80 | cp >> 6 & 0x3F);
                            out.write(0x80 | cp & 0x3F);
                            ++i;
                            continue;
                        }
                        out.write(63);
                        continue;
                    }
                    out.write(63);
                    continue;
                }
                out.write(63);
                continue;
            }
            out.write(0xE0 | c >> 12);
            out.write(0x80 | c >> 6 & 0x3F);
            out.write(0x80 | c & 0x3F);
        }
    }

    public static void writeUTF8HtmlEscaped(OutputStream out, String src) throws IOException {
        int limit = src.length();
        for (int i = 0; i < limit; ++i) {
            char c = src.charAt(i);
            if (c < '\u0080') {
                switch (c) {
                    case '<': {
                        out.write(38);
                        out.write(108);
                        out.write(116);
                        out.write(59);
                        break;
                    }
                    case '>': {
                        out.write(38);
                        out.write(103);
                        out.write(116);
                        out.write(59);
                        break;
                    }
                    case '&': {
                        out.write(38);
                        out.write(97);
                        out.write(109);
                        out.write(112);
                        out.write(59);
                        break;
                    }
                    case '\"': {
                        out.write(38);
                        out.write(113);
                        out.write(117);
                        out.write(111);
                        out.write(116);
                        out.write(59);
                        break;
                    }
                    case '\'': {
                        out.write(38);
                        out.write(97);
                        out.write(112);
                        out.write(111);
                        out.write(115);
                        out.write(59);
                        break;
                    }
                    default: {
                        out.write(c);
                        break;
                    }
                }
                continue;
            }
            if (c < '\u0800') {
                out.write(0xC0 | c >> 6);
                out.write(0x80 | c & 0x3F);
                continue;
            }
            if (Character.isSurrogate(c)) {
                if (Character.isHighSurrogate(c)) {
                    int next = i + 1;
                    if (next < limit) {
                        char nextChar = src.charAt(next);
                        if (Character.isLowSurrogate(nextChar)) {
                            int cp = Character.toCodePoint(c, nextChar);
                            out.write(0xF0 | cp >> 18);
                            out.write(0x80 | cp >> 12 & 0x3F);
                            out.write(0x80 | cp >> 6 & 0x3F);
                            out.write(0x80 | cp & 0x3F);
                            ++i;
                            continue;
                        }
                        out.write(63);
                        continue;
                    }
                    out.write(63);
                    continue;
                }
                out.write(63);
                continue;
            }
            out.write(0xE0 | c >> 12);
            out.write(0x80 | c >> 6 & 0x3F);
            out.write(0x80 | c & 0x3F);
        }
    }
}

