/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.db.impl.inmem;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.beany.PropertySelector;
import org.rapidoid.db.Database;
import org.rapidoid.db.DbList;
import org.rapidoid.db.DbRef;
import org.rapidoid.db.DbSet;
import org.rapidoid.db.impl.DbHelper;
import org.rapidoid.db.impl.DbRelationInternals;
import org.rapidoid.db.impl.inmem.InMemDbList;
import org.rapidoid.db.impl.inmem.InMemDbRef;
import org.rapidoid.db.impl.inmem.InMemDbSet;
import org.rapidoid.inmem.EntitySerializer;
import org.rapidoid.log.Log;
import org.rapidoid.util.U;

public class JacksonEntitySerializer
implements EntitySerializer {
    private final Database db;
    private final ObjectMapper mapper = new ObjectMapper();

    public JacksonEntitySerializer(Database db) {
        this.db = db;
        this.initDbMapper();
    }

    private void initDbMapper() {
        SimpleModule dbModule = new SimpleModule("DbModule", new Version(1, 0, 0, null, null, null));
        dbModule.addDeserializer(DbList.class, (JsonDeserializer)new JsonDeserializer<DbList>(){

            public DbList deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                Map data = (Map)jp.readValueAs(Map.class);
                String relation = (String)data.get("relation");
                List ids = (List)data.get("ids");
                return new InMemDbList(JacksonEntitySerializer.this.db, null, relation, ids);
            }
        });
        dbModule.addDeserializer(DbSet.class, (JsonDeserializer)new JsonDeserializer<DbSet>(){

            public DbSet deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                Map data = (Map)jp.readValueAs(Map.class);
                String relation = (String)data.get("relation");
                List ids = (List)data.get("ids");
                return new InMemDbSet(JacksonEntitySerializer.this.db, null, relation, ids);
            }
        });
        dbModule.addDeserializer(DbRef.class, (JsonDeserializer)new JsonDeserializer<DbRef>(){

            public DbRef deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                Map data = (Map)jp.readValueAs(Map.class);
                String relation = (String)data.get("relation");
                List ids = (List)data.get("ids");
                U.must((ids.size() <= 1 ? 1 : 0) != 0, (String)"Expected 0 or 1 IDs!");
                long id = !ids.isEmpty() ? ((Number)ids.get(0)).longValue() : -1L;
                return new InMemDbRef(JacksonEntitySerializer.this.db, null, relation, id);
            }
        });
        this.mapper.registerModule((Module)dbModule);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String stringify(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] stringifyWithExtras(Object value, Object ... extras) {
        if (extras.length % 2 != 0) {
            throw new IllegalArgumentException("Expected even number of extras (key1, value1, key2, value2...), but found: " + extras.length);
        }
        try {
            JsonNode node = this.mapper.valueToTree(value);
            if (!(node instanceof ObjectNode)) {
                throw new RuntimeException("Cannot add extra attributes on a non-object value: " + value);
            }
            ObjectNode obj = (ObjectNode)node;
            int extrasN = extras.length / 2;
            for (int i = 0; i < extrasN; ++i) {
                Object key = extras[2 * i];
                if (!(key instanceof String)) {
                    throw new RuntimeException("Expected extra key of type String, but found: " + key);
                }
                obj.put((String)key, String.valueOf(extras[2 * i + 1]));
            }
            return this.mapper.writeValueAsBytes((Object)node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void parse(byte[] bytes, T destination) {
        try {
            Map map = (Map)this.mapper.readValue(bytes, Map.class);
            Beany.update(destination, (Map)map, (boolean)false);
        }
        catch (Exception e) {
            Log.error((String)"Cannot parse JSON!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] serialize(Object entity) {
        Class entityType = this.db.schema().getEntityTypeFor(entity.getClass());
        return this.stringifyWithExtras(Beany.serialize((Object)entity), "_class", entityType.getCanonicalName());
    }

    public <T> void deserialize(byte[] bytes, T destination) {
        this.parse(bytes, destination);
        for (Prop prop : Beany.propertiesOf(destination).select((PropertySelector)DbHelper.DB_REL_PROPS)) {
            DbRelationInternals rel = (DbRelationInternals)prop.get(destination);
            U.notNull((Object)rel, (String)prop.getName(), (Object[])new Object[0]);
            rel.setHolder(destination);
        }
    }
}

