/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Coll;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Future;
import org.rapidoid.data.JSON;
import org.rapidoid.http.HttpClient;
import org.rapidoid.http.HttpResp;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.io.Upload;

public class HttpReq
extends RapidoidThing {
    private final HttpClient client;
    private volatile HttpVerb verb = null;
    private volatile String url = null;
    private volatile byte[] body = null;
    private final Map<String, String> headers = Coll.synchronizedMap();
    private final Map<String, Object> data = Coll.synchronizedMap();
    private final Map<String, List<Upload>> files = Coll.synchronizedMap();
    private volatile String contentType = null;
    private volatile boolean raw = false;
    private volatile int socketTimeout = 5000;
    private volatile int connectTimeout = 5000;
    private volatile int connectionRequestTimeout = 5000;

    public HttpReq(HttpClient client) {
        this.client = client;
    }

    public HttpReq verb(HttpVerb verb) {
        this.verb = verb;
        return this;
    }

    public HttpReq verb(String verb) {
        return this.verb(HttpVerb.from((String)verb.toUpperCase()));
    }

    public HttpVerb verb() {
        return this.verb;
    }

    public HttpReq url(String url) {
        this.url = url;
        return this;
    }

    public String url() {
        return this.url;
    }

    public HttpReq body(byte[] body) {
        this.body = body;
        return this;
    }

    public byte[] body() {
        return this.body;
    }

    public HttpReq headers(Map<String, String> headers) {
        Coll.assign(this.headers, headers);
        return this;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public HttpReq data(Map<String, ?> data) {
        Coll.assign(this.data, data);
        return this;
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public HttpReq files(Map<String, List<Upload>> files) {
        Coll.assign(this.files, files);
        return this;
    }

    public Map<String, List<Upload>> files() {
        return this.files;
    }

    public HttpReq contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public String fetch() {
        return this.execute().body();
    }

    public String fetchRaw() {
        this.raw(true);
        try {
            String string = this.execute().body();
            return string;
        }
        finally {
            this.raw(false);
        }
    }

    public HttpReq raw(boolean raw) {
        this.raw = raw;
        return this;
    }

    public boolean raw() {
        return this.raw;
    }

    public HttpReq header(String name, String value) {
        this.headers().put(name, value);
        return this;
    }

    public HttpReq data(String name, Object value) {
        this.data().put(name, value);
        return this;
    }

    public HttpReq file(String name, List<Upload> files) {
        this.files().put(name, files);
        return this;
    }

    public HttpReq socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public HttpReq connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public HttpReq connectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public int connectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public <T> T parse() {
        return (T)JSON.parse((String)this.fetch());
    }

    public HttpResp execute() {
        return (HttpResp)((Object)this.client.executeRequest(this, null).get());
    }

    public Future<HttpResp> execute(Callback<HttpResp> callback) {
        return this.client.executeRequest(this, callback);
    }

    public HttpReq get(String url) {
        return this.verb(HttpVerb.GET).url(url);
    }

    public HttpReq post(String url) {
        return this.verb(HttpVerb.POST).url(url);
    }

    public HttpReq put(String url) {
        return this.verb(HttpVerb.PUT).url(url);
    }

    public HttpReq delete(String url) {
        return this.verb(HttpVerb.DELETE).url(url);
    }

    public HttpReq patch(String url) {
        return this.verb(HttpVerb.PATCH).url(url);
    }

    public HttpReq options(String url) {
        return this.verb(HttpVerb.OPTIONS).url(url);
    }

    public HttpReq head(String url) {
        return this.verb(HttpVerb.HEAD).url(url);
    }

    public HttpReq trace(String url) {
        return this.verb(HttpVerb.TRACE).url(url);
    }
}

