/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.integrate;

import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.persistence.EntityManagerFactory;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Env;
import org.rapidoid.ioc.BeanProvider;
import org.rapidoid.ioc.IoC;
import org.rapidoid.jpa.JPA;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public abstract class SpringIntegrator
extends RapidoidThing
implements Runnable,
BeanProvider {
    @Resource
    private ConfigurableApplicationContext ctx;

    @PostConstruct
    public void postConstructInitialization() {
        U.notNull((Object)this.ctx, (String)"ConfigurableApplicationContext ctx", (Object[])new Object[0]);
        if (this.useProfiles()) {
            this.initProfiles();
        }
        if (this.useEmf() && JPA.getEmf() == null && Msc.hasJPA()) {
            this.initJPA();
        }
        if (this.useBeans()) {
            this.initBeans();
        }
        this.run();
    }

    protected void initProfiles() {
        Collections.addAll(Env.profiles(), this.ctx.getEnvironment().getActiveProfiles());
    }

    protected void initJPA() {
        EntityManagerFactory emf;
        try {
            emf = (EntityManagerFactory)this.ctx.getBean(EntityManagerFactory.class);
        }
        catch (Exception e) {
            return;
        }
        JPA.setEmf((EntityManagerFactory)emf);
    }

    protected void initBeans() {
        IoC.defaultContext().beanProvider((BeanProvider)this);
    }

    public <T> T getBean(Class<T> type, String name) {
        U.notNull((Object)this.ctx, (String)"ConfigurableApplicationContext ctx", (Object[])new Object[0]);
        try {
            return (T)this.ctx.getBean(name, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean useProfiles() {
        return true;
    }

    protected boolean useEmf() {
        return true;
    }

    protected boolean useBeans() {
        return true;
    }
}

