/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.inject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.annotation.Autocreate;
import org.rapidoid.annotation.Init;
import org.rapidoid.annotation.Inject;
import org.rapidoid.annotation.Session;
import org.rapidoid.beany.Beany;
import org.rapidoid.config.Conf;
import org.rapidoid.lambda.F3;
import org.rapidoid.lambda.Lambdas;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.util.Builder;
import org.rapidoid.util.Cls;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;

public class IoC {
    private static final Map<Class<?>, Object> SINGLETONS = U.map();
    private static final Set<Class<?>> MANAGED_CLASSES = U.set((Object[])new Object[0]);
    private static final Set<Object> MANAGED_INSTANCES = U.set((Object[])new Object[0]);
    private static final Map<Object, Object> IOC_INSTANCES = U.map();
    private static final Map<Class<?>, List<Field>> INJECTABLE_FIELDS = UTILS.autoExpandingMap((Mapper)new Mapper<Class<?>, List<Field>>(){

        public List<Field> map(Class<?> clazz) throws Exception {
            List fields = Cls.getFieldsAnnotated(clazz, Inject.class);
            Log.debug((String)"Retrieved injectable fields", (String)"class", clazz, (String)"fields", (Object)fields);
            return fields;
        }
    });
    private static final Map<Class<?>, List<Field>> SESSION_FIELDS = UTILS.autoExpandingMap((Mapper)new Mapper<Class<?>, List<Field>>(){

        public List<Field> map(Class<?> clazz) throws Exception {
            List fields = Cls.getFieldsAnnotated(clazz, Session.class);
            Log.debug((String)"Retrieved session fields", (String)"class", clazz, (String)"fields", (Object)fields);
            return fields;
        }
    });
    private static final Map<Class<?>, Set<Object>> INJECTION_PROVIDERS = U.map();
    private static final Map<Class<?>, List<F3<Object, Object, Method, Object[]>>> INTERCEPTORS = U.map();

    public static synchronized void reset() {
        Log.info((String)"Reseting IoC state");
        Log.setLogLevel((LogLevel)Log.INFO);
        Conf.args((String[])new String[0]);
        Beany.reset();
        SINGLETONS.clear();
        MANAGED_CLASSES.clear();
        MANAGED_INSTANCES.clear();
        IOC_INSTANCES.clear();
        INJECTABLE_FIELDS.clear();
        SESSION_FIELDS.clear();
        INJECTION_PROVIDERS.clear();
        INTERCEPTORS.clear();
    }

    public static <K, V> Map<K, V> autoExpandingInjectingMap(final Class<V> clazz) {
        return UTILS.autoExpandingMap((Mapper)new Mapper<K, V>(){

            public V map(K src) throws Exception {
                return IoC.inject(Cls.newInstance((Class)clazz));
            }
        });
    }

    public static synchronized void manage(Object ... classesOrInstances) {
        ArrayList autocreate = new ArrayList();
        for (Object classOrInstance : classesOrInstances) {
            boolean isClass = IoC.isClass(classOrInstance);
            Class<?> clazz = isClass ? (Class<?>)classOrInstance : classOrInstance.getClass();
            for (Class interfacee : Cls.getImplementedInterfaces(clazz)) {
                IoC.addInjectionProvider(interfacee, classOrInstance);
            }
            if (isClass) {
                Log.debug((String)"configuring managed class", (String)"class", (Object)classOrInstance);
                MANAGED_CLASSES.add(clazz);
                if (clazz.isInterface() || clazz.isEnum() || clazz.isAnnotation() || clazz.getAnnotation(Autocreate.class) == null) continue;
                autocreate.add(clazz);
                continue;
            }
            Log.debug((String)"configuring managed instance", (String)"instance", (Object)classOrInstance);
            IoC.addInjectionProvider(clazz, classOrInstance);
            MANAGED_INSTANCES.add(classOrInstance);
        }
        for (Class clazz : autocreate) {
            IoC.singleton(clazz);
        }
    }

    private static void addInjectionProvider(Class<?> type, Object provider) {
        Set providers = INJECTION_PROVIDERS.get(type);
        if (providers == null) {
            providers = U.set((Object[])new Object[0]);
            INJECTION_PROVIDERS.put(type, providers);
        }
        providers.add((Object)provider);
    }

    public static synchronized <T> T singleton(Class<T> type) {
        Log.debug((String)"Inject", (String)"type", type);
        return IoC.provideIoCInstanceOf(null, type, null, null, false);
    }

    public static synchronized <T> T autowire(T target) {
        Log.debug((String)"Autowire", (String)"target", target);
        IoC.autowire(target, null, null);
        return target;
    }

    public static synchronized <T> T autowire(T target, Mapper<String, Object> session) {
        Log.debug((String)"Autowire", (String)"target", target);
        IoC.autowire(target, null, session);
        return target;
    }

    public static synchronized <T> T inject(T target) {
        Log.debug((String)"Inject", (String)"target", target);
        return IoC.ioc(target, null);
    }

    public static synchronized <T> T inject(T target, Map<String, Object> properties) {
        Log.debug((String)"Inject", (String)"target", target, (String)"properties", properties);
        return IoC.ioc(target, properties);
    }

    private static <T> T provideSessionValue(Object target, Class<T> type, String name, Mapper<String, Object> session) {
        U.notNull(session, (String)"session", (Object[])new Object[0]);
        Object value = Lambdas.eval(session, (Object)name);
        return (T)(value != null ? Cls.convert((Object)value, type) : null);
    }

    private static <T> T provideIoCInstanceOf(Object target, Class<T> type, String name, Map<String, Object> properties, boolean optional) {
        T instance = null;
        if (name != null) {
            instance = IoC.provideInstanceByName(target, type, name, properties);
        }
        if (instance == null) {
            instance = IoC.provideIoCInstanceByType(type, properties);
        }
        if (instance == null && IoC.canInjectNew(type)) {
            instance = IoC.provideNewIoCInstanceOf(type, properties);
        }
        if (!optional && instance == null) {
            if (name != null) {
                throw U.rte((String)"Didn't find a value for type '%s' and name '%s'!", (Object[])new Object[]{type, name});
            }
            throw U.rte((String)"Didn't find a value for type '%s'!", (Object[])new Object[]{type});
        }
        return instance != null ? IoC.ioc(instance, properties) : null;
    }

    private static boolean canInjectNew(Class<?> type) {
        return !type.isAnnotation() && !type.isEnum() && !type.isInterface() && !type.isPrimitive() && !type.equals(String.class) && !type.equals(Object.class) && !type.equals(Boolean.class) && !Number.class.isAssignableFrom(type);
    }

    private static <T> T provideNewIoCInstanceOf(Class<T> type, Map<String, Object> properties) {
        if (!(type.isInterface() || type.isEnum() || type.isAnnotation())) {
            Object instance = SINGLETONS.get(type);
            if (instance == null) {
                instance = IoC.ioc(Cls.newInstance(type, properties), properties);
            }
            return (T)instance;
        }
        return null;
    }

    private static <T> T provideIoCInstanceByType(Class<T> type, Map<String, Object> properties) {
        Set<Object> providers = INJECTION_PROVIDERS.get(type);
        if (providers != null && !providers.isEmpty()) {
            Object provider = null;
            for (Object pr : providers) {
                if (provider == null) {
                    provider = pr;
                    continue;
                }
                if (IoC.isClass(provider) && !IoC.isClass(pr)) {
                    provider = pr;
                    continue;
                }
                if (!IoC.isClass(provider) && IoC.isClass(pr)) continue;
                throw U.rte((String)"Found more than 1 injection candidates for type '%s': %s", (Object[])new Object[]{type, providers});
            }
            if (provider != null) {
                return IoC.provideFrom(provider, properties);
            }
        }
        return null;
    }

    private static <T> T provideFrom(Object classOrInstance, Map<String, Object> properties) {
        Object instance = IoC.isClass(classOrInstance) ? IoC.provideNewIoCInstanceOf((Class)classOrInstance, properties) : classOrInstance;
        return (T)instance;
    }

    private static boolean isClass(Object obj) {
        return obj instanceof Class;
    }

    private static <T> T provideInstanceByName(Object target, Class<T> type, String name, Map<String, Object> properties) {
        T instance = IoC.getInjectableByName(type, name, properties, false);
        if (target != null) {
            instance = IoC.getInjectableByName(type, target.getClass().getSimpleName() + "." + name, properties, true);
        }
        if (instance == null) {
            instance = IoC.getInjectableByName(type, name, properties, true);
        }
        return instance;
    }

    private static <T> T getInjectableByName(Class<T> type, String name, Map<String, Object> properties, boolean useConfig) {
        Object instance;
        Object object = instance = properties != null ? properties.get(name) : null;
        if (instance == null && useConfig) {
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                instance = Conf.is((String)name);
            } else {
                String opt = Conf.option((String)name, (String)null);
                if (opt != null) {
                    instance = Cls.convert((String)opt, type);
                }
            }
        }
        return (T)instance;
    }

    private static void autowire(Object target, Map<String, Object> properties, Mapper<String, Object> session) {
        Log.debug((String)"Autowiring", (String)"target", (Object)target);
        for (Field field : INJECTABLE_FIELDS.get(target.getClass())) {
            boolean optional = IoC.isInjectOptional(field);
            Object value = IoC.provideIoCInstanceOf(target, field.getType(), field.getName(), properties, optional);
            Log.debug((String)"Injecting field value", (String)"target", (Object)target, (String)"field", (Object)field.getName(), (String)"value", value);
            if (optional && value == null) continue;
            Cls.setFieldValue((Object)target, (String)field.getName(), value);
        }
        for (Field field : SESSION_FIELDS.get(target.getClass())) {
            Object value = IoC.provideSessionValue(target, field.getType(), field.getName(), session);
            if (value == null) continue;
            Log.debug((String)"Injecting session field value", (String)"target", (Object)target, (String)"field", (Object)field.getName(), (String)"value", value);
            Cls.setFieldValue((Object)target, (String)field.getName(), value);
        }
    }

    private static boolean isInjectOptional(Field field) {
        Inject inject = field.getAnnotation(Inject.class);
        return inject != null && inject.optional();
    }

    private static <T> void invokePostConstruct(T target) {
        List methods = Cls.getMethodsAnnotated(target.getClass(), Init.class);
        for (Method method : methods) {
            Cls.invoke((Method)method, target, (Object[])new Object[0]);
        }
    }

    private static <T> T ioc(T target, Map<String, Object> properties) {
        if (!IoC.isIocProcessed(target)) {
            IOC_INSTANCES.put(target, null);
            IoC.manage(target);
            IoC.autowire(target, properties, null);
            IoC.invokePostConstruct(target);
            T proxy = IoC.proxyWrap(target);
            IOC_INSTANCES.put(target, proxy);
            IoC.manage(proxy);
            target = proxy;
        }
        return target;
    }

    private static boolean isIocProcessed(Object target) {
        for (Map.Entry<Object, Object> e : IOC_INSTANCES.entrySet()) {
            if (e.getKey() != target && e.getValue() != target) continue;
            return true;
        }
        return false;
    }

    private static <T> T proxyWrap(T instance) {
        Set done = U.set((Object[])new Object[0]);
        for (Class interf : Cls.getImplementedInterfaces(instance.getClass())) {
            List<F3<Object, Object, Method, Object[]>> interceptors = INTERCEPTORS.get(interf);
            if (interceptors == null) continue;
            for (final F3<Object, Object, Method, Object[]> interceptor : interceptors) {
                if (interceptor == null || done.contains(interceptor)) continue;
                Log.debug((String)"Creating proxy", (String)"target", instance, (String)"interface", (Object)interf, (String)"interceptor", interceptor);
                final T target = instance;
                InvocationHandler handler = new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        return interceptor.execute(target, (Object)method, (Object)args);
                    }
                };
                instance = Cls.implement(instance, (InvocationHandler)handler, (Class[])new Class[]{interf});
                done.add(interceptor);
            }
        }
        return instance;
    }

    public static <T, B extends Builder<T>> B builder(Class<B> builderClass, Class<T> builtClass, final Class<? extends T> implClass) {
        final Map properties = U.map();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().equals(Builder.class)) {
                    return IoC.inject(Cls.newInstance((Class)implClass, (Map)properties), properties);
                }
                U.must((args.length == 1 ? 1 : 0) != 0, (String)"expected 1 argument!");
                properties.put(method.getName(), args[0]);
                return proxy;
            }
        };
        Builder builder = (Builder)Cls.implement((InvocationHandler)handler, (Class[])new Class[]{builderClass});
        return (B)builder;
    }

    public static synchronized List<Field> getSessionFields(Object target) {
        return SESSION_FIELDS.get(target.getClass());
    }
}

