/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.rapidoid.log.LogLevel;

public class Log {
    public static final LogLevel TRACE = LogLevel.TRACE;
    public static final LogLevel DEBUG = LogLevel.DEBUG;
    public static final LogLevel AUDIT = LogLevel.AUDIT;
    public static final LogLevel INFO = LogLevel.INFO;
    public static final LogLevel WARN = LogLevel.WARN;
    public static final LogLevel ERROR = LogLevel.ERROR;
    public static final LogLevel SEVERE = LogLevel.SEVERE;
    protected static LogLevel LOG_LEVEL = AUDIT;
    private static Appendable LOG_OUTPUT = System.out;

    private Log() {
    }

    public static synchronized void args(String ... args) {
        for (String arg : args) {
            if (!arg.equals("debug") || Log.getLogLevel().ordinal() <= DEBUG.ordinal()) continue;
            Log.setLogLevel(DEBUG);
        }
    }

    public static synchronized void setLogLevel(LogLevel logLevel) {
        LOG_LEVEL = logLevel;
    }

    public static synchronized LogLevel getLogLevel() {
        return LOG_LEVEL;
    }

    private static String getCallingClass() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < trace.length; ++i) {
            String cls = trace[i].getClassName();
            if (cls.equals(Log.class.getCanonicalName())) continue;
            return cls;
        }
        return Log.class.getCanonicalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(Appendable out, LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, int paramsN) {
        if (level.ordinal() >= LOG_LEVEL.ordinal()) {
            try {
                Appendable appendable = out;
                synchronized (appendable) {
                    out.append(level.name());
                    out.append(" | ");
                    out.append(Thread.currentThread().getName());
                    out.append(" | ");
                    out.append(Log.getCallingClass());
                    out.append(" | ");
                    out.append(msg);
                    switch (paramsN) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            Log.printKeyValue(out, key1, value1);
                            break;
                        }
                        case 2: {
                            Log.printKeyValue(out, key1, value1);
                            Log.printKeyValue(out, key2, value2);
                            break;
                        }
                        case 3: {
                            Log.printKeyValue(out, key1, value1);
                            Log.printKeyValue(out, key2, value2);
                            Log.printKeyValue(out, key3, value3);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    out.append('\n');
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void printKeyValue(Appendable out, String key, Object value) throws IOException {
        out.append(" | ");
        out.append(key);
        out.append("=");
        out.append(Log.printable(value));
        if (value instanceof Throwable) {
            Throwable err = (Throwable)value;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            err.printStackTrace(new PrintStream(stream));
            out.append("\n");
            out.append(stream.toString());
        }
    }

    private static String printable(Object value) {
        return String.valueOf(value);
    }

    public static synchronized void setLogOutput(Appendable logOutput) {
        LOG_OUTPUT = logOutput;
    }

    private static void log(LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, int paramsN) {
        Log.log(LOG_OUTPUT, level, msg, key1, value1, key2, value2, key3, value3, paramsN);
    }

    public static void trace(String msg) {
        Log.log(TRACE, msg, null, null, null, null, null, null, 0);
    }

    public static void trace(String msg, String key, Object value) {
        Log.log(TRACE, msg, key, value, null, null, null, null, 1);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(TRACE, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(TRACE, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void debug(String msg) {
        Log.log(DEBUG, msg, null, null, null, null, null, null, 0);
    }

    public static void debug(String msg, String key, Object value) {
        Log.log(DEBUG, msg, key, value, null, null, null, null, 1);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(DEBUG, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(DEBUG, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void audit(String msg) {
        Log.log(AUDIT, msg, null, null, null, null, null, null, 0);
    }

    public static void audit(String msg, String key, Object value) {
        Log.log(AUDIT, msg, key, value, null, null, null, null, 1);
    }

    public static void audit(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(AUDIT, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void audit(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(AUDIT, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void info(String msg) {
        Log.log(INFO, msg, null, null, null, null, null, null, 0);
    }

    public static void info(String msg, String key, Object value) {
        Log.log(INFO, msg, key, value, null, null, null, null, 1);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(INFO, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(INFO, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void warn(String msg) {
        Log.log(WARN, msg, null, null, null, null, null, null, 0);
    }

    public static void warn(String msg, String key, Object value) {
        Log.log(WARN, msg, key, value, null, null, null, null, 1);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(WARN, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(WARN, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void warn(String msg, Throwable error) {
        Log.warn(msg, "error", error);
    }

    public static void error(String msg) {
        Log.log(ERROR, msg, null, null, null, null, null, null, 0);
    }

    public static void error(String msg, String key, Object value) {
        Log.log(ERROR, msg, key, value, null, null, null, null, 1);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(ERROR, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(ERROR, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void error(String msg, Throwable error) {
        Log.error(msg, "error", error);
    }

    public static void error(Throwable error) {
        Log.error("error occured!", "error", error);
    }

    public static void severe(String msg) {
        Log.log(SEVERE, msg, null, null, null, null, null, null, 0);
    }

    public static void severe(String msg, String key, Object value) {
        Log.log(SEVERE, msg, key, value, null, null, null, null, 1);
    }

    public static void severe(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(SEVERE, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void severe(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(SEVERE, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void severe(String msg, Throwable error) {
        Log.severe(msg, "error", error);
    }
}

