/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.model.impl;

import java.util.Collections;
import java.util.List;
import org.rapidoid.cls.Cls;
import org.rapidoid.model.Item;
import org.rapidoid.model.Models;
import org.rapidoid.model.Property;
import org.rapidoid.model.impl.ListItems;
import org.rapidoid.util.U;

public class BeanListItems<T>
extends ListItems {
    private static final long serialVersionUID = 7346765152583871241L;
    protected final Class<T> beanType;

    public BeanListItems(Class<T> beanType) {
        this.beanType = beanType;
    }

    @Override
    public List<Property> properties(Object ... properties) {
        return properties.length == 0 ? this.inferProperties() : this.filterProperties(properties);
    }

    private List<Property> inferProperties() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Object item0 = this.get(0).value();
        return Models.propertiesOf(item0, new String[0]);
    }

    private List<Property> filterProperties(Object[] properties) {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List props = U.list((Object[])new Property[0]);
        Object item0 = this.get(0).value();
        for (Object prop : properties) {
            if (prop instanceof String) {
                String strProp = (String)prop;
                props.add(Models.propertyOf(Cls.of((Object)item0), strProp));
                continue;
            }
            if (prop instanceof Property) {
                props.add((Property)prop);
                continue;
            }
            throw U.rte((String)"Invalid property: %s!", (Object[])new Object[]{prop});
        }
        return props;
    }

    @Override
    public boolean fitsIn(Item item) {
        return super.fitsIn(item) && (this.beanType == null || Cls.instanceOf((Object)item.value(), (Class[])new Class[]{this.beanType}));
    }
}

