/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.model.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import org.rapidoid.commons.Str;
import org.rapidoid.model.Item;
import org.rapidoid.model.Property;

public class BeanProperty
implements Property {
    private static final long serialVersionUID = 7627370931428864929L;
    private final String name;
    private final Class<?> type;
    private final ParameterizedType genericType;
    private final String caption;
    private final Annotation[] annotations;

    public BeanProperty(String name, Class<?> type, ParameterizedType genericType, Annotation[] annotations) {
        this(name, type, genericType, annotations, BeanProperty.pretty(name));
    }

    public BeanProperty(String name, Class<?> type, ParameterizedType genericType, Annotation[] annotations, String caption) {
        this.name = name;
        this.type = type;
        this.annotations = annotations;
        this.caption = caption;
        this.genericType = genericType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public String caption() {
        return this.caption;
    }

    @Override
    public Annotation[] annotations() {
        return this.annotations;
    }

    @Override
    public ParameterizedType genericType() {
        return this.genericType;
    }

    static String pretty(String prop) {
        if (prop.startsWith("_") && ((prop = prop.substring(1)).equals("toString") || prop.equals("str"))) {
            prop = "data";
        }
        if (prop.equals("id")) {
            return "ID";
        }
        return Str.camelPhrase((String)prop);
    }

    public String toString() {
        return "BeanProperty [name=" + this.name + ", type=" + this.type + ", genericType=" + this.genericType + ", caption=" + this.caption + "]";
    }

    @Override
    public Object get(Item item) {
        return item.get(this.name);
    }
}

