/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.oauth;

import org.rapidoid.config.Conf;
import org.rapidoid.crypto.Crypto;
import org.rapidoid.oauth.OAuthStateCheck;
import org.rapidoid.util.Rnd;

public class DefaultOAuthStateCheck
implements OAuthStateCheck {
    @Override
    public String generateState(String clientSecret, String sessionId) {
        if (Conf.is((String)"oauth-no-state")) {
            return "OK";
        }
        String rnd = Rnd.rndStr((int)10);
        String hash = Crypto.md5((String)(clientSecret + rnd));
        return rnd + "_" + hash;
    }

    @Override
    public boolean isValidState(String state, String clientSecret, String sessionId) {
        if (Conf.is((String)"oauth-no-state")) {
            return state.equals("OK");
        }
        String[] parts = state.split("_");
        if (parts.length != 2) {
            return false;
        }
        String hash = Crypto.md5((String)(clientSecret + parts[0]));
        return parts[1].equals(hash);
    }
}

