/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.oauth;

import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.rapidoid.config.Conf;
import org.rapidoid.http.HTMLSnippets;
import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.oauth.DefaultOAuthStateCheck;
import org.rapidoid.oauth.OAuthLoginHandler;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.oauth.OAuthStateCheck;
import org.rapidoid.oauth.OAuthTokenHandler;
import org.rapidoid.util.U;

public class OAuth {
    private static final String LOGIN_BTN = "<div class=\"row-fluid\"><div class=\"col-md-3\"><a href=\"/_%sLogin\" class=\"btn btn-default btn-block\">Login with %s</a></div></div>";
    private static OAuthStateCheck STATE_CHECK;

    public static void register(HTTPServer server, OAuthProvider ... providers) {
        OAuth.register(server, null, new DefaultOAuthStateCheck(), providers);
    }

    public static void register(HTTPServer server, String oauthDomain, OAuthStateCheck stateCheck, OAuthProvider ... providers) {
        if (Conf.oauth() == null) {
            return;
        }
        oauthDomain = (String)U.or((Object)oauthDomain, (Object)Conf.option((String)"oauth-domain", (String)null));
        STATE_CHECK = stateCheck;
        if (providers == null || providers.length == 0) {
            providers = OAuthProvider.PROVIDERS;
        }
        final StringBuilder loginHtml = new StringBuilder();
        loginHtml.append("<div class=\"container-fluid text-center\">");
        for (OAuthProvider provider : providers) {
            String name = provider.getName().toLowerCase();
            String loginPath = "/_" + name + "Login";
            String callbackPath = "/_" + name + "OauthCallback";
            String clientId = Conf.option((String)(name + ".clientId"), (String)"NO-CLIENT-ID");
            String clientSecret = Conf.option((String)(name + ".clientSecret"), (String)"NO-CLIENT-SECRET");
            server.get(loginPath, (Handler)new OAuthLoginHandler(provider, oauthDomain));
            server.get(callbackPath, (Handler)new OAuthTokenHandler(provider, oauthDomain, stateCheck, clientId, clientSecret, callbackPath));
            loginHtml.append(U.format((String)LOGIN_BTN, (Object[])new Object[]{name, provider.getName()}));
        }
        loginHtml.append("</div>");
        server.get("/_oauthLogin", new Handler(){

            public Object handle(HttpExchange x) throws Exception {
                return HTMLSnippets.writePage((HttpExchange)x, (String)"Login with OAuth provider", (String)loginHtml.toString());
            }
        });
    }

    public static String getLoginURL(HttpExchange x, OAuthProvider provider, String oauthDomain) {
        if (Conf.oauth() == null) {
            return "";
        }
        oauthDomain = (String)U.or((Object)oauthDomain, (Object)Conf.option((String)"oauth-domain", (String)null));
        String name = provider.getName().toLowerCase();
        String clientId = Conf.option((String)(name + ".clientId"), (String)"NO-CLIENT-ID");
        String clientSecret = Conf.option((String)(name + ".clientSecret"), (String)"NO-CLIENT-SECRET");
        String callbackPath = "/_" + name + "OauthCallback.html";
        String redirectUrl = oauthDomain != null ? oauthDomain + callbackPath : x.constructUrl(callbackPath);
        String state = STATE_CHECK.generateState(clientSecret, x.sessionId());
        try {
            OAuthClientRequest request = OAuthClientRequest.authorizationLocation((String)provider.getAuthEndpoint()).setClientId(clientId).setRedirectURI(redirectUrl).setScope(provider.getEmailScope()).setState(state).setResponseType("code").buildQueryMessage();
            return request.getLocationUri();
        }
        catch (OAuthSystemException e) {
            throw U.rte((Throwable)e);
        }
    }
}

