/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.oauth;

import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigEntry;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.log.Log;
import org.rapidoid.oauth.DefaultOAuthStateCheck;
import org.rapidoid.oauth.OAuthLoginHandler;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.oauth.OAuthStateCheck;
import org.rapidoid.oauth.OAuthTokenHandler;
import org.rapidoid.util.U;
import org.rapidoid.webapp.AppCtx;
import org.rapidoid.webapp.WebApp;

public class OAuth {
    private static final String LOGIN_BTN = "<div class=\"row-fluid\"><div class=\"col-md-3\"><a href=\"/_%sLogin\" class=\"btn btn-default btn-block\">Login with %s</a></div></div>";
    private static OAuthStateCheck STATE_CHECK;

    public static void register(WebApp app, OAuthProvider ... providers) {
        OAuth.register(app, new DefaultOAuthStateCheck(), providers);
    }

    public static void register(WebApp app, OAuthStateCheck stateCheck, OAuthProvider ... providers) {
        Config appcfg = app.getConfig();
        if (!appcfg.has("oauth")) {
            Log.warn((String)"OAuth is currently not configured!");
        }
        ConfigEntry oauthDomain = appcfg.entry(new String[]{"domain"}).byDefault(null);
        STATE_CHECK = stateCheck;
        if (providers == null || providers.length == 0) {
            providers = OAuthProvider.PROVIDERS;
        }
        final StringBuilder loginHtml = new StringBuilder();
        loginHtml.append("<div class=\"container-fluid text-center\">");
        for (OAuthProvider provider : providers) {
            String name = provider.getName().toLowerCase();
            String loginPath = "/_" + name + "Login";
            String callbackPath = "/_" + name + "OauthCallback";
            ConfigEntry clientId = appcfg.entry(new String[]{"oauth", name, "id"}).byDefault((Object)"NO-CLIENT-ID-CONFIGURED");
            ConfigEntry clientSecret = appcfg.entry(new String[]{"oauth", name, "secret"}).byDefault((Object)"NO-CLIENT-SECRET-CONFIGURED");
            app.getRouter().get(loginPath, (Handler)new OAuthLoginHandler(provider, oauthDomain));
            app.getRouter().get(callbackPath, (Handler)new OAuthTokenHandler(provider, oauthDomain, stateCheck, clientId, clientSecret, callbackPath));
            loginHtml.append(U.format((String)LOGIN_BTN, (Object[])new Object[]{name, provider.getName()}));
        }
        loginHtml.append("</div>");
        app.getRouter().get("/_oauthLogin", new Handler(){

            public Object handle(HttpExchange x) throws Exception {
                return x.renderPage((Object)U.map((Object)"title", (Object)"Login with OAuth provider", (Object)"content", (Object)loginHtml.toString(), (Object)"navbar", (Object)true));
            }
        });
    }

    public static String getLoginURL(HttpExchange x, OAuthProvider provider, String oauthDomain) {
        WebApp app = AppCtx.app();
        Config appcfg = app.getConfig();
        if (!appcfg.has("oauth")) {
            Log.warn((String)"OAuth is currently not configured!");
        }
        String name = provider.getName().toLowerCase();
        String clientId = (String)appcfg.entry(new String[]{"oauth", name, "id"}).byDefault((Object)"NO-CLIENT-ID-CONFIGURED").get();
        String clientSecret = (String)appcfg.entry(new String[]{"oauth", name, "secret"}).byDefault((Object)"NO-CLIENT-SECRET-CONFIGURED").get();
        String callbackPath = "/_" + name + "OauthCallback";
        boolean popup = x.param("popup", null) != null;
        String redirectUrl = oauthDomain != null ? oauthDomain + callbackPath : x.constructUrl(callbackPath);
        String statePrefix = popup ? "P" : "N";
        String state = statePrefix + STATE_CHECK.generateState(clientSecret, x.sessionId());
        try {
            OAuthClientRequest request = OAuthClientRequest.authorizationLocation((String)provider.getAuthEndpoint()).setClientId(clientId).setRedirectURI(redirectUrl).setScope(provider.getEmailScope()).setState(state).setResponseType("code").buildQueryMessage();
            return request.getLocationUri();
        }
        catch (OAuthSystemException e) {
            throw U.rte((Throwable)e);
        }
    }
}

