/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.oauth;

import java.util.Map;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.GitHubTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.rapidoid.config.ConfigEntry;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.UserInfo;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.jackson.JSON;
import org.rapidoid.log.Log;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.oauth.OAuthStateCheck;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;

public class OAuthTokenHandler
implements Handler {
    private final OAuthProvider provider;
    private final ConfigEntry oauthDomain;
    private final OAuthStateCheck stateCheck;
    private final ConfigEntry clientId;
    private final ConfigEntry clientSecret;
    private final String callbackPath;

    public OAuthTokenHandler(OAuthProvider provider, ConfigEntry oauthDomain, OAuthStateCheck stateCheck, ConfigEntry clientId, ConfigEntry clientSecret, String callbackPath) {
        this.provider = provider;
        this.oauthDomain = oauthDomain;
        this.stateCheck = stateCheck;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.callbackPath = callbackPath;
    }

    public Object handle(HttpExchange x) throws Exception {
        String code = x.param("code");
        String state = x.param("state");
        Log.debug((String)"Received OAuth code", (String)"code", (Object)code, (String)"state", (Object)state);
        if (code != null && !U.isEmpty((String)state)) {
            String id = (String)this.clientId.get();
            String secret = (String)this.clientSecret.get();
            char statePrefix = state.charAt(0);
            U.must((statePrefix == 'P' || statePrefix == 'N' ? 1 : 0) != 0, (String)"Invalid OAuth state prefix!");
            state = state.substring(1);
            U.must((boolean)this.stateCheck.isValidState(state, secret, x.sessionId()), (String)"Invalid OAuth state!");
            boolean popup = statePrefix == 'P';
            Log.debug((String)"OAuth validated", (String)"popup", (Object)popup);
            String domain = (String)this.oauthDomain.get();
            String redirectUrl = domain != null ? domain + this.callbackPath : x.constructUrl(this.callbackPath);
            OAuthClientRequest.TokenRequestBuilder reqBuilder = OAuthClientRequest.tokenLocation((String)this.provider.getTokenEndpoint()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(id).setClientSecret(secret).setRedirectURI(redirectUrl).setCode(code);
            OAuthClientRequest request = this.paramsInBody() ? reqBuilder.buildBodyMessage() : reqBuilder.buildBodyMessage();
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            String accessToken = this.token(request, oAuthClient);
            String profileUrl = UTILS.fillIn((String)this.provider.getProfileEndpoint(), (String)"token", (String)accessToken);
            OAuthClientRequest bearerClientRequest = new OAuthBearerClientRequest(profileUrl).setAccessToken(accessToken).buildQueryMessage();
            OAuthResourceResponse res = (OAuthResourceResponse)oAuthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
            U.must((res.getResponseCode() == 200 ? 1 : 0) != 0, (String)"OAuth response error!");
            Map auth = JSON.parseMap((String)res.getBody());
            String firstName = (String)U.or(auth.get("firstName"), (Object)U.or(auth.get("first_name"), auth.get("given_name")));
            String lastName = (String)U.or(auth.get("lastName"), (Object)U.or(auth.get("last_name"), auth.get("family_name")));
            UserInfo user = new UserInfo();
            user.name = (String)U.or((Object)((String)auth.get("name")), (Object)(firstName + " " + lastName));
            user.oauthProvider = this.provider.getName();
            user.username = user.email = (String)U.or(auth.get("email"), auth.get("emailAddress"));
            user.oauthId = String.valueOf(auth.get("id"));
            Ctxs.ctx().setUser(user);
            user.saveTo(x.cookiepack());
            return x.goBack(1);
        }
        String error = x.param("error");
        if (error != null) {
            Log.warn((String)"OAuth error", (String)"error", (Object)error);
            throw U.rte((String)"OAuth error!");
        }
        throw U.rte((String)"Invalid OAuth request!");
    }

    private String token(OAuthClientRequest request, OAuthClient oAuthClient) throws Exception {
        String name = this.provider.getName();
        if (name.equalsIgnoreCase("facebook") || name.equalsIgnoreCase("github")) {
            GitHubTokenResponse oAuthResponse = (GitHubTokenResponse)oAuthClient.accessToken(request, GitHubTokenResponse.class);
            return oAuthResponse.getAccessToken();
        }
        OAuthJSONAccessTokenResponse oAuthResponse = (OAuthJSONAccessTokenResponse)oAuthClient.accessToken(request, OAuthJSONAccessTokenResponse.class);
        return oAuthResponse.getAccessToken();
    }

    private boolean paramsInBody() {
        return this.provider.getName().equalsIgnoreCase("google");
    }
}

