/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.oauth;

import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Rnd;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.crypto.Crypto;
import org.rapidoid.oauth.OAuthStateCheck;
import org.rapidoid.value.Value;

public class DefaultOAuthStateCheck
extends RapidoidThing
implements OAuthStateCheck {
    private static final Config OAUTH = Conf.OAUTH;

    @Override
    public String generateState(Value<String> clientSecret, String sessionId) {
        if (OAUTH.is("stateless")) {
            return "OK";
        }
        String rnd = Rnd.rndStr((int)10);
        String hash = Crypto.sha512((String)((String)clientSecret.get() + rnd));
        return rnd + "_" + hash;
    }

    @Override
    public boolean isValidState(String state, String clientSecret, String sessionId) {
        if (OAUTH.is("stateless")) {
            return state.equals("OK");
        }
        String[] parts = state.split("_");
        if (parts.length != 2) {
            return false;
        }
        String hash = Crypto.sha512((String)(clientSecret + parts[0]));
        return parts[1].equals(hash);
    }
}

