/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.quick;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.Transactional;
import org.rapidoid.annotation.Transaction;
import org.rapidoid.aop.AOP;
import org.rapidoid.aop.AOPInterceptor;
import org.rapidoid.app.Apps;
import org.rapidoid.app.AuthInterceptor;
import org.rapidoid.app.TransactionInterceptor;
import org.rapidoid.cls.Cls;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.PersisterProvider;
import org.rapidoid.job.Jobs;
import org.rapidoid.log.Log;
import org.rapidoid.plugins.Plugin;
import org.rapidoid.plugins.Plugins;
import org.rapidoid.plugins.db.DBPlugin;
import org.rapidoid.plugins.db.hibernate.HibernateDBPlugin;
import org.rapidoid.quick.QuickJPA;
import org.rapidoid.security.annotation.Admin;
import org.rapidoid.security.annotation.DevMode;
import org.rapidoid.security.annotation.LoggedIn;
import org.rapidoid.security.annotation.Manager;
import org.rapidoid.security.annotation.Moderator;
import org.rapidoid.security.annotation.Role;
import org.rapidoid.security.annotation.Roles;
import org.rapidoid.util.U;
import org.rapidoid.webapp.WebApp;
import org.rapidoid.webapp.WebAppGroup;

public class Quick {
    public static void run(WebApp app, String[] args, Object ... config) {
        Quick.bootstrap(app, args, config);
        Quick.serve(app, args, config);
    }

    public static void serve(WebApp app, String[] args, Object ... config) {
        Apps.serve((WebApp)app, (String[])args, (Object[])config);
    }

    public static void bootstrap(WebApp app, String[] args, Object ... config) {
        Apps.bootstrap((WebApp)app, (String[])args, (Object[])config);
        WebAppGroup.main().setDefaultApp(app);
        WebAppGroup.main().register(app);
        Ctx ctx = Ctxs.open((String)"quick");
        ctx.setApp((Object)app);
        Ctxs.setPersisterProvider((PersisterProvider)new QuickJPA(config));
        Class cassandraPluginCls = Cls.getClassIfExists((String)"org.rapidoid.plugins.db.cassandra.CassandraDBPlugin");
        if (cassandraPluginCls != null) {
            Log.info((String)"Detected Casandra plugin");
            DBPlugin dbPlugin = (DBPlugin)Cls.newInstance((Class)cassandraPluginCls);
            Plugins.register((Plugin)dbPlugin);
        }
        Plugins.register((Plugin)new HibernateDBPlugin());
        AOP.reset();
        AOP.intercept((AOPInterceptor)new AuthInterceptor(), (Class[])new Class[]{Admin.class, Manager.class, Moderator.class, LoggedIn.class, DevMode.class, Role.class, Roles.class});
        AOP.intercept((AOPInterceptor)new TransactionInterceptor(), (Class[])new Class[]{Transaction.class, Transactional.class});
        Jobs.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Log.info((String)"The executor is ready.");
            }
        });
    }

    public static EntityManager createJPAEM(Object[] args) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"pu", (Map)U.map());
        EntityManager em = emf.createEntityManager();
        return em;
    }
}

