package org.rapidoid.app;

/*
 * #%L
 * rapidoid-quick
 * %%
 * Copyright (C) 2014 - 2016 Nikolche Mihajlovski and contributors
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.io.File;
import java.util.List;

import org.rapidoid.annotation.Authors;
import org.rapidoid.annotation.P;
import org.rapidoid.annotation.Since;

@Authors("Nikolche Mihajlovski")
@Since("4.2.0")
public interface IOTool {

	List<File> files(@P("dir") String dir);

	List<String> filenames(@P("dir") String dir);

	byte[] load(@P("filename") String filename);

	void save(@P("filename") String filename, @P("data") byte[] data);

	File file(@P("filename") String filename);

}
