/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.quick;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.Transactional;
import org.rapidoid.annotation.Transaction;
import org.rapidoid.aop.AOP;
import org.rapidoid.aop.AOPInterceptor;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.PersisterProvider;
import org.rapidoid.job.Jobs;
import org.rapidoid.log.Log;
import org.rapidoid.plugins.Plugin;
import org.rapidoid.plugins.Plugins;
import org.rapidoid.plugins.db.hibernate.HibernateDBPlugin;
import org.rapidoid.quick.QuickJPA;
import org.rapidoid.u.U;
import org.rapidoid.web.Rapidoid;
import org.rapidoid.web.WebApp;
import org.rapidoid.web.WebAppGroup;
import org.rapidoid.webapp.TransactionInterceptor;

public class Quick {
    public static void bootstrap(WebApp app, String[] args, Object ... config) {
        app = Rapidoid.bootstrap((WebApp)app, (String[])args, (Object[])config);
        WebAppGroup.main().setDefaultApp(app);
        WebAppGroup.main().register(app);
        Ctx ctx = Ctxs.open((String)"quick");
        ctx.setApp((Object)app);
        Ctxs.setPersisterProvider((PersisterProvider)new QuickJPA(config));
        Plugins.register((Plugin)new HibernateDBPlugin());
        AOP.intercept((AOPInterceptor)new TransactionInterceptor(), (Class[])new Class[]{Transaction.class, Transactional.class});
        Jobs.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Log.info((String)"The executor is ready.");
            }
        });
    }

    public static EntityManager createJPAEM(Object[] args) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"pu", (Map)U.map());
        EntityManager em = emf.createEntityManager();
        return em;
    }
}

