/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.quick;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.boot.internal.SettingsImpl;
import org.hibernate.jpa.internal.EntityManagerFactoryImpl;
import org.rapidoid.config.Conf;
import org.rapidoid.ctx.PersisterProvider;
import org.rapidoid.io.IO;
import org.rapidoid.scan.Scan;
import org.rapidoid.u.U;

public class QuickJPA
implements PersisterProvider {
    private final Object[] args;
    private static HibernateEntityManagerFactory emFactory;

    public QuickJPA(Object ... args) {
        this.args = args;
    }

    private static synchronized HibernateEntityManagerFactory emFactory(Object[] args) {
        if (emFactory == null) {
            AnnotationConfiguration cfg = new AnnotationConfiguration();
            List entityTypes = Scan.annotated(Entity.class).getClasses();
            for (Class entityType : entityTypes) {
                cfg.addAnnotatedClass(entityType);
            }
            for (Object arg : args) {
                Class entityType;
                if (!(arg instanceof Class) || entityTypes.contains(entityType = (Class)arg)) continue;
                cfg.addAnnotatedClass(entityType);
            }
            cfg.addProperties(QuickJPA.hibernateProperties());
            SessionFactory sf = cfg.buildSessionFactory();
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sf;
            SettingsImpl settings = new SettingsImpl();
            emFactory = new EntityManagerFactoryImpl("pu", sfi, settings, U.map(), (Configuration)cfg);
        }
        return emFactory;
    }

    public static Properties hibernateProperties() {
        Map props;
        Properties properties = new Properties();
        if (Conf.production()) {
            props = IO.loadMap((String)"hibernate-prod.properties");
            if (props == null) {
                props = IO.loadMap((String)"hibernate-prod.default.properties");
            }
        } else {
            props = IO.loadMap((String)"hibernate-dev.properties");
            if (props == null) {
                props = IO.loadMap((String)"hibernate-dev.default.properties");
            }
        }
        if (props != null) {
            properties.putAll((Map<?, ?>)props);
        }
        return properties;
    }

    public <P> P openPersister() {
        return (P)QuickJPA.emFactory(this.args).createEntityManager();
    }

    public void closePersister(Object persister) {
        EntityManager em = (EntityManager)persister;
        em.close();
    }
}

