/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.quick;

import java.util.List;
import java.util.Map;
import org.rapidoid.app.IOTool;
import org.rapidoid.app.IOToolImpl;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.http.HTTP;
import org.rapidoid.http.HttpClient;
import org.rapidoid.http.REST;
import org.rapidoid.http.RESTClient;
import org.rapidoid.http.Req;
import org.rapidoid.plugins.Plugins;
import org.rapidoid.plugins.cache.CachePlugin;
import org.rapidoid.plugins.db.DBPlugin;
import org.rapidoid.plugins.email.EmailPlugin;
import org.rapidoid.plugins.entities.EntitiesPlugin;
import org.rapidoid.plugins.sms.SMSPlugin;
import org.rapidoid.plugins.templates.TemplatesPlugin;
import org.rapidoid.quick.JedisTool;
import org.rapidoid.quick.Tools;
import org.rapidoid.sql.SQL;
import org.rapidoid.sql.SQLAPI;
import redis.clients.jedis.Jedis;

public class ToolsImpl
implements Tools {
    private static volatile ToolsImpl INSTANCE;
    private final HttpClient http = HTTP.DEFAULT_CLIENT;
    private final RESTClient services = REST.DEFAULT_CLIENT;
    private final DBPlugin db = Plugins.db();
    private final DBPlugin hibernate = Plugins.db((String)"hibernate");
    private final DBPlugin cassandra = Plugins.db((String)"cassandra");
    private final EntitiesPlugin entities = Plugins.entities();
    private final EmailPlugin email = Plugins.email();
    private final SMSPlugin sms = Plugins.sms();
    private final CachePlugin cache = Plugins.cache();
    private final CachePlugin memcached = Plugins.cache((String)"memcached");
    private final TemplatesPlugin templates = Plugins.templates();
    private final SQLAPI mysql = SQL.defaultInstance();
    private final IOTool io = new IOToolImpl();
    private final SQLAPI jdbc = SQL.defaultInstance();

    public static ToolsImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ToolsImpl();
        }
        return INSTANCE;
    }

    @Override
    public List<Map<String, Object>> sql(String sql, Object ... args) {
        if (sql.trim().toLowerCase().startsWith("select ")) {
            return this.jdbc.query(sql, args);
        }
        this.jdbc.execute(sql, args);
        return null;
    }

    @Override
    public List<Map<String, Object>> cql(String cql, Object ... args) {
        return this.cassandra.query(cql, args);
    }

    @Override
    public void cql(String cql, Callback<List<Map<String, Object>>> callback, Object ... args) {
        this.cassandra.queryAsync(cql, callback, args);
    }

    @Override
    public Req req() {
        return (Req)Ctxs.ctx().exchange();
    }

    @Override
    public void result(Object result) {
        this.req().response().content(result).done();
    }

    @Override
    public HttpClient http() {
        return this.http;
    }

    @Override
    public RESTClient services() {
        return this.services;
    }

    @Override
    public DBPlugin db() {
        return this.db;
    }

    @Override
    public DBPlugin hibernate() {
        return this.hibernate;
    }

    @Override
    public DBPlugin cassandra() {
        return this.cassandra;
    }

    @Override
    public EntitiesPlugin entities() {
        return this.entities;
    }

    @Override
    public EmailPlugin email() {
        return this.email;
    }

    @Override
    public SMSPlugin sms() {
        return this.sms;
    }

    @Override
    public CachePlugin cache() {
        return this.cache;
    }

    @Override
    public CachePlugin memcached() {
        return this.memcached;
    }

    @Override
    public TemplatesPlugin templates() {
        return this.templates;
    }

    @Override
    public SQLAPI mysql() {
        return this.mysql;
    }

    @Override
    public IOTool io() {
        return this.io;
    }

    @Override
    public SQLAPI jdbc() {
        return this.jdbc;
    }

    @Override
    public Jedis redis() {
        return JedisTool.get();
    }
}

