/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.webapp;

import org.rapidoid.beany.Beany;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Usage;

public class Apps {
    public static <T> T config(Object obj, String configName, T byDefault) {
        Object val = Beany.getPropValue((Object)obj, (String)configName, null);
        return (T)(val != null ? val : byDefault);
    }

    public static boolean addon(Object obj, String configName) {
        return Apps.config(obj, configName, false) != false || Apps.config(obj, "full", true) != false;
    }

    public static void terminate(final int afterSeconds) {
        Log.warn((String)("Terminating application in " + afterSeconds + " seconds..."));
        new Thread(){

            @Override
            public void run() {
                U.sleep((long)(afterSeconds * 1000));
                Apps.terminate();
            }
        }.start();
    }

    public static void terminateIfIdleFor(final int idleSeconds) {
        Log.warn((String)("Will terminate if idle for " + idleSeconds + " seconds..."));
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    U.sleep((long)500L);
                    long lastUsed = Usage.getLastAppUsedOn();
                    long idleSec = (U.time() - lastUsed) / 1000L;
                    if (idleSec < (long)idleSeconds) continue;
                    Usage.touchLastAppUsedOn();
                    Apps.terminate();
                }
            }
        }).start();
    }

    public static void terminate() {
        Log.warn((String)"Terminating application.");
        System.exit(0);
    }
}

