/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.webapp;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.rapidoid.annotation.Transaction;
import org.rapidoid.annotation.TransactionMode;
import org.rapidoid.aop.AOPInterceptor;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.http.Req;
import org.rapidoid.http.fast.HttpUtils;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.log.Log;
import org.rapidoid.plugins.db.DB;
import org.rapidoid.u.U;

public class TransactionInterceptor
implements AOPInterceptor {
    public Object intercept(final Callable<Object> forward, Annotation ann, Object ctx, Method m, Object target, Object[] args) {
        boolean readOnly;
        final Req req = (Req)Ctxs.ctx().exchange();
        TransactionMode txMode = this.getTxMode(ann);
        if (txMode == TransactionMode.AUTO) {
            U.notNull((Object)req, (String)"HTTP request", (Object[])new Object[0]);
            readOnly = HttpUtils.isGetReq((Req)req);
        } else {
            readOnly = txMode == TransactionMode.READ_ONLY;
        }
        req.async();
        DB.transaction((Runnable)new Runnable(){

            @Override
            public void run() {
                req.response().content(Lmbd.call((Callable)forward));
            }
        }, (boolean)readOnly, (Callback)new Callback<Void>(){

            public void onDone(Void result, Throwable error) throws Exception {
                if (error != null) {
                    req.response().content((Object)error);
                }
                req.done();
            }
        });
        return req;
    }

    private TransactionMode getTxMode(Annotation ann) {
        if (ann instanceof Transaction) {
            Transaction tx = (Transaction)ann;
            TransactionMode txMode = tx.value();
            return txMode;
        }
        Log.warn((String)"Providing LIMITED support for this transaction annotation!", (String)"annotation", (Object)ann);
        return TransactionMode.AUTO;
    }
}

