/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Coll;
import org.rapidoid.io.Res;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.render.RapidoidTemplate;
import org.rapidoid.render.Template;
import org.rapidoid.render.TemplateParser;
import org.rapidoid.render.TemplateRenderer;

public class Templates
extends RapidoidThing {
    private static final Map<String, TemplateRenderer> TEMPLATES = Coll.autoExpandingMap((Mapper)new Mapper<String, TemplateRenderer>(){

        public TemplateRenderer map(String name) throws Exception {
            return TemplateParser.parse(Templates.resource(name).mustExist().getContent()).compile();
        }
    });

    public static Template fromFile(String filename) {
        return new RapidoidTemplate(filename, TEMPLATES.get(filename));
    }

    public static Template fromString(String source) {
        return new RapidoidTemplate("", TemplateParser.parse(source).compile());
    }

    public static Res resource(String filename) {
        return Res.from((String)filename, (String[])new String[]{"templates", "default/templates", ""});
    }

    public static Template fromRes(Res template) {
        return Templates.fromFile(template.getName());
    }

    public static void reset() {
        TEMPLATES.clear();
    }
}

