/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.commons.Coll;
import org.rapidoid.commons.Str;
import org.rapidoid.render.Getter;
import org.rapidoid.render.RenderCtx;
import org.rapidoid.render.Templates;
import org.rapidoid.u.U;

public class RenderCtxImpl
extends RapidoidThing
implements RenderCtx {
    private final OutputStream out;
    private final String ext;
    private final List<Object> model;

    public RenderCtxImpl(OutputStream out, String filename, Object ... model) {
        this.out = out;
        this.model = U.list((Object[])model);
        String fileExt = Str.cutFromFirst((String)filename, (String)".");
        this.ext = fileExt != null ? "." + fileExt : "";
    }

    @Override
    public void print(String s) {
        try {
            this.out.write(s.getBytes());
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
    }

    @Override
    public Object[] iter(String name) {
        Object val = this.get(name);
        if (val instanceof Collection) {
            return ((Collection)val).toArray();
        }
        if (val instanceof Object[]) {
            return (Object[])val;
        }
        return val != null && !Boolean.FALSE.equals(val) ? U.array((Object[])new Object[]{val}) : U.array((Object[])new Object[0]);
    }

    @Override
    public void val(String name, boolean escape) {
        this.valOr(name, "N/A", escape);
    }

    @Override
    public void valOr(String name, String or, boolean escape) {
        Object val = name.equals(".") ? this.self() : this.get(name);
        val = U.or((Object)val, (Object)or);
        this.print(this.str(escape, val));
    }

    private String str(boolean escape, Object val) {
        String str = U.str((Object)val);
        if (escape) {
            str = Str.htmlEscape((String)str);
        }
        return str;
    }

    private Object self() {
        return !this.model.isEmpty() ? this.model.get(this.model.size() - 1) : null;
    }

    @Override
    public void push(int index, Object v) {
        if (v != null && !Boolean.TRUE.equals(v)) {
            this.model.add(v);
        }
    }

    @Override
    public void pop(int index, Object v) {
        if (v != null && !Boolean.TRUE.equals(v)) {
            Object del = this.model.remove(this.model.size() - 1);
            U.must((del == v ? 1 : 0) != 0);
        }
    }

    @Override
    public void call(String name) {
        Templates.fromFile(name + this.ext).renderTo(this.out, this.model.toArray());
    }

    @Override
    public boolean cond(String name) {
        Object val = this.get(name);
        return !(val == null || Boolean.FALSE.equals(val) || Coll.isCollection((Object)val) && U.isEmpty((Collection)((Collection)val)) || Coll.isMap((Object)val) && U.isEmpty((Map)((Map)val)));
    }

    private Object get(String name) {
        return RenderCtxImpl.propOf(name, this.model.toArray());
    }

    private static Object propOf(String name, Object[] scope) {
        int p = name.indexOf(".");
        if (p > 0) {
            Object first = RenderCtxImpl.propOf(name.substring(0, p), scope);
            return RenderCtxImpl.propOf(name.substring(p + 1), new Object[]{first});
        }
        for (int i = scope.length - 1; i >= 0; --i) {
            Object x = scope[i];
            if (x == null) continue;
            if (x instanceof Map) {
                Map map = (Map)x;
                if (!map.containsKey(name)) continue;
                return map.get(name);
            }
            if (x instanceof Getter) {
                Getter getter = (Getter)x;
                return getter.get(name);
            }
            Prop prop = Beany.property((Object)x, (String)name, (boolean)false);
            if (prop == null) continue;
            return prop.get(x);
        }
        return null;
    }
}

