/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import java.util.concurrent.atomic.AtomicInteger;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Err;
import org.rapidoid.commons.Str;
import org.rapidoid.render.XNode;
import org.rapidoid.u.U;

public class TemplateToCode
extends RapidoidThing {
    public static final AtomicInteger ID_GEN = new AtomicInteger();
    public static final String Q = "\"";

    public static String generate(XNode x) {
        switch (x.op) {
            case OP_ROOT: {
                return "{" + U.join((String)"", x.children) + "}";
            }
            case OP_TEXT: {
                return TemplateToCode.print(TemplateToCode.literal(x.text));
            }
            case OP_PRINT: {
                return TemplateToCode.val(x.text, true);
            }
            case OP_PRINT_RAW: {
                return TemplateToCode.val(x.text, false);
            }
            case OP_IF_NOT: {
                String body = U.join((String)"", x.children);
                return U.frmt((String)"if (!$1.cond(%s)) { %s }", (Object[])new Object[]{TemplateToCode.literal(x.text), body});
            }
            case OP_IF: {
                String body = U.join((String)"", x.children);
                return U.frmt((String)"if ($1.cond(%s)) { %s }", (Object[])new Object[]{TemplateToCode.literal(x.text), body});
            }
            case OP_INCLUDE: {
                return U.frmt((String)"$1.call(%s);", (Object[])new Object[]{TemplateToCode.literal(x.text)});
            }
            case OP_FOREACH: {
                String body = U.join((String)"", x.children);
                String arr = "v" + ID_GEN.incrementAndGet();
                String i = "v" + ID_GEN.incrementAndGet();
                String code = "Object[] %s = $1.iter(\"%s\"); for (int %s = 0; %s < %s.length; %s++) {\n %s\n }";
                return U.frmt((String)code, (Object[])new Object[]{arr, x.text, i, i, arr, i, TemplateToCode.scoped(i, arr, body)});
            }
        }
        throw Err.notExpected();
    }

    static String scoped(String i, String arr, String code) {
        String var = arr + "[" + i + "]";
        return U.frmt((String)"$1.push(%s, %s); try { %s } finally { $1.pop(%s, %s); }", (Object[])new Object[]{i, var, code, i, var});
    }

    static String print(String s) {
        return U.frmt((String)"$1.print(%s);\n", (Object[])new Object[]{s});
    }

    static String val(String s, boolean escape) {
        String[] parts = s.split("\\|\\|", 2);
        if (parts.length == 2) {
            return U.frmt((String)"$1.valOr(%s, %s, %s);\n", (Object[])new Object[]{TemplateToCode.literal(parts[0]), TemplateToCode.literal(parts[1]), escape});
        }
        return U.frmt((String)"$1.val(%s, %s);\n", (Object[])new Object[]{TemplateToCode.literal(s), escape});
    }

    static String literal(String s) {
        return Q + Str.javaEscape((String)s) + Q;
    }
}

