/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.render.RenderCtx;
import org.rapidoid.render.TemplateRenderer;
import org.rapidoid.render.TemplateToCode;
import org.rapidoid.render.XNode;
import org.rapidoid.u.U;

public class TemplateCompiler
extends RapidoidThing {
    public static final AtomicInteger ID_GEN = new AtomicInteger();

    public static TemplateRenderer compile(XNode node) {
        try {
            Map expressions = U.map();
            String source = TemplateToCode.generate(node, expressions);
            return TemplateCompiler.tryToCompile(source, expressions);
        }
        catch (NotFoundException e) {
            throw U.rte((Throwable)e);
        }
        catch (CannotCompileException e) {
            throw U.rte((Throwable)e);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    private static TemplateRenderer tryToCompile(String source, Map<String, String> expressions) throws NotFoundException, CannotCompileException, InstantiationException, IllegalAccessException {
        ClassPool cp = ClassPool.getDefault();
        CtClass sup = cp.get(Object.class.getCanonicalName());
        CtClass cls = cp.makeClass("RapidoidTemplate" + ID_GEN.incrementAndGet(), sup);
        cls.addInterface(cp.get(TemplateRenderer.class.getCanonicalName()));
        cls.addConstructor(CtNewConstructor.defaultConstructor((CtClass)cls));
        for (Map.Entry<String, String> expr : expressions.entrySet()) {
            String fld = "private static final org.rapidoid.render.retriever.ValueRetriever %s = org.rapidoid.render.retriever.Retriever.of(%s);";
            String retrieverId = TemplateCompiler.retrieverId(expr.getKey());
            String prop = expr.getValue();
            String field = U.frmt((String)fld, (Object[])new Object[]{retrieverId, prop});
            cls.addField(CtField.make((String)field, (CtClass)cls));
        }
        CtClass[] params = new CtClass[]{cp.get(RenderCtx.class.getCanonicalName())};
        CtClass clsVoid = cp.get(Void.TYPE.getCanonicalName());
        cls.addMethod(CtNewMethod.make((int)1, (CtClass)clsVoid, (String)"render", (CtClass[])params, (CtClass[])new CtClass[0], (String)source, (CtClass)cls));
        return (TemplateRenderer)cls.toClass().newInstance();
    }

    public static String retrieverId(String expr) {
        String id = expr.replaceAll("[^A-Za-z0-9_]", "\\$");
        return "_$_" + id + "_$_";
    }
}

