/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Err;
import org.rapidoid.commons.Str;
import org.rapidoid.render.TemplateCompiler;
import org.rapidoid.render.XNode;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class TemplateToCode
extends RapidoidThing {
    public static final AtomicInteger ID_GEN = new AtomicInteger();
    public static final String Q = "\"";

    public static String generate(XNode x, Map<String, String> expressions) {
        switch (x.op) {
            case OP_ROOT: {
                return "{" + TemplateToCode.join("", x.children, expressions) + "}";
            }
            case OP_TEXT: {
                return U.notEmpty((String)x.text) ? TemplateToCode.print(TemplateToCode.literal(x.text)) : "";
            }
            case OP_PRINT: {
                return TemplateToCode.val(x.text, true, expressions);
            }
            case OP_PRINT_RAW: {
                return TemplateToCode.val(x.text, false, expressions);
            }
            case OP_IF_NOT: {
                String body = TemplateToCode.join("", x.children, expressions);
                return U.frmt((String)"if (!$1.cond(%s)) { %s }", (Object[])new Object[]{TemplateToCode.literal(x.text), body});
            }
            case OP_IF: {
                String body = TemplateToCode.join("", x.children, expressions);
                return U.frmt((String)"if ($1.cond(%s)) { %s }", (Object[])new Object[]{TemplateToCode.literal(x.text), body});
            }
            case OP_INCLUDE: {
                return U.frmt((String)"$1.call(%s);", (Object[])new Object[]{TemplateToCode.literal(x.text)});
            }
            case OP_FOREACH: {
                String body = TemplateToCode.join("", x.children, expressions);
                String retrId = TemplateToCode.expr(expressions, x.text);
                return TemplateToCode.iterList(body, retrId);
            }
        }
        throw Err.notExpected();
    }

    private static String iterList(String body, String retrId) {
        String list = "v" + ID_GEN.incrementAndGet();
        String ind = "v" + ID_GEN.incrementAndGet();
        String code = "java.util.List %s = $1.iter(%s); for (int %s = 0; %s < %s.size(); %s++) {\n %s\n }";
        return U.frmt((String)code, (Object[])new Object[]{list, retrId, ind, ind, list, ind, TemplateToCode.scopedList(ind, list, body)});
    }

    private static String iterArr(String body, String retrId) {
        String arr = "v" + ID_GEN.incrementAndGet();
        String ind = "v" + ID_GEN.incrementAndGet();
        String code = "Object[] %s = $1.iter(%s); for (int %s = 0; %s < %s.length; %s++) {\n %s\n }";
        return U.frmt((String)code, (Object[])new Object[]{arr, retrId, ind, ind, arr, ind, TemplateToCode.scopedArr(ind, arr, body)});
    }

    private static String eachIter(String body, String retrId) {
        String it = "v" + ID_GEN.incrementAndGet();
        String var = "v" + ID_GEN.incrementAndGet();
        String ind = "v" + ID_GEN.incrementAndGet();
        String insideBody = TemplateToCode.scopedIter(ind, var, body);
        String code = "java.util.Iterator %s = $1.iter(%s);\nint %s = 0;\n while (%s.hasNext()) {\nObject %s = %s.next();\n %s++;\n%s\n }";
        return U.frmt((String)code, (Object[])new Object[]{it, retrId, ind, it, var, it, ind, insideBody});
    }

    private static String join(String separator, List<XNode> nodes, Map<String, String> expressions) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nodes.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            String code = TemplateToCode.generate(nodes.get(i), expressions);
            sb.append(code);
        }
        return sb.toString();
    }

    static String scopedList(String ind, String list, String code) {
        String var = list + ".get(" + ind + ")";
        return U.frmt((String)"$1.push(%s, %s); try { %s } finally { $1.pop(%s, %s); }", (Object[])new Object[]{ind, var, code, ind, var});
    }

    static String scopedArr(String i, String arr, String code) {
        String var = arr + "[" + i + "]";
        return U.frmt((String)"$1.push(%s, %s); try { %s } finally { $1.pop(%s, %s); }", (Object[])new Object[]{i, var, code, i, var});
    }

    static String scopedIter(String ind, String var, String code) {
        return U.frmt((String)"$1.push(%s, %s); try { %s } finally { $1.pop(%s, %s); }", (Object[])new Object[]{ind, var, code, ind, var});
    }

    static String print(String s) {
        if (s.isEmpty()) {
            return "";
        }
        if (Msc.isAscii((String)s)) {
            return U.frmt((String)"$1.printAscii(%s);\n", (Object[])new Object[]{s});
        }
        return U.frmt((String)"$1.printUTF8(%s);\n", (Object[])new Object[]{s});
    }

    static String val(String s, boolean escape, Map<String, String> expressions) {
        String[] parts = s.split("\\|\\|", 2);
        if (parts.length == 2) {
            String prop = parts[0];
            String orElse = TemplateToCode.literal(parts[1]);
            String retrId = TemplateToCode.expr(expressions, prop);
            return U.frmt((String)"$1.valOr(%s, %s, %s);\n", (Object[])new Object[]{retrId, orElse, escape});
        }
        String retrId = TemplateToCode.expr(expressions, s);
        return U.frmt((String)"$1.val(%s, %s);\n", (Object[])new Object[]{retrId, escape});
    }

    static String literal(String s) {
        return Q + Str.javaEscape((String)s) + Q;
    }

    private static String expr(Map<String, String> expressions, String expr) {
        expressions.put(expr, TemplateToCode.literal(expr));
        return TemplateCompiler.retrieverId(expr);
    }
}

