/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jdbc;

import org.rapidoid.AbstractRapidoidModule;
import org.rapidoid.annotation.RapidoidModuleDesc;
import org.rapidoid.jdbc.JDBC;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.log.Log;

@RapidoidModuleDesc(name="SQL", order=500)
public class SQLModule
extends AbstractRapidoidModule {
    private static final String HSQLDB_DRIVER = "org.hsqldb.jdbc.JDBCDriver";
    public static final String HSQLDB_TRUNCATE = "TRUNCATE SCHEMA PUBLIC RESTART IDENTITY AND COMMIT NO CHECK";
    public static final String HSQLDB_DROP_ALL = "DROP SCHEMA public CASCADE";
    private static final String H2_DRIVER = "org.h2.Driver";
    public static final String H2_DROP_ALL = "DROP ALL OBJECTS DELETE FILES";

    public void afterTest(Object test) {
        SQLModule.cleanInMemDatabases();
        this.cleanUp();
    }

    public void cleanUp() {
        JDBC.reset();
    }

    private static void cleanInMemDatabases() {
        for (String name : JDBC.apiNames()) {
            JdbcClient jdbc = JDBC.api(name);
            if (!jdbc.isInitialized()) continue;
            if (HSQLDB_DRIVER.equals(jdbc.driver())) {
                Log.info((String)"Dropping all objects in the HSQLDB database");
                jdbc.execute(HSQLDB_TRUNCATE, new Object[0]);
                jdbc.execute(HSQLDB_DROP_ALL, new Object[0]);
            }
            if (!H2_DRIVER.equals(jdbc.driver())) continue;
            Log.info((String)"Dropping all objects in the H2 database");
            jdbc.execute(H2_DROP_ALL, new Object[0]);
        }
    }
}

