/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import org.rapidoid.util.Classes;
import org.rapidoid.util.U;
import org.rapidoid.util.UserInfo;

public class AppCtx {
    private static final ThreadLocal<AppCtx> CTXS = new ThreadLocal();
    private UserInfo user;
    private Object exchange;
    private Classes classes;

    private AppCtx() {
    }

    private static AppCtx ctx() {
        AppCtx ctx = CTXS.get();
        U.must((ctx != null ? 1 : 0) != 0, (String)"App ctx wasn't set!");
        return ctx;
    }

    private static AppCtx provideCtx() {
        AppCtx ctx = CTXS.get();
        if (ctx == null) {
            ctx = new AppCtx();
            CTXS.set(ctx);
        }
        return ctx;
    }

    public static void reset() {
        CTXS.remove();
    }

    public static void setUser(UserInfo user) {
        AppCtx ctx = AppCtx.provideCtx();
        U.must((ctx.user == null ? 1 : 0) != 0, (String)"The username was already set!");
        ctx.user = user;
    }

    public static UserInfo user() {
        AppCtx ctx = CTXS.get();
        return ctx != null ? ctx.user : null;
    }

    public static void delUser() {
        AppCtx ctx = AppCtx.ctx();
        ctx.user = null;
    }

    public static void setExchange(Object exchange) {
        AppCtx ctx = AppCtx.provideCtx();
        U.must((ctx.exchange == null ? 1 : 0) != 0, (String)"The exchange was already set!");
        ctx.exchange = exchange;
    }

    public static <T> T exchange() {
        AppCtx ctx = CTXS.get();
        return (T)(ctx != null ? ctx.exchange : null);
    }

    public static void delExchange() {
        AppCtx ctx = AppCtx.ctx();
        ctx.exchange = null;
    }

    public static void setClasses(Classes classes) {
        AppCtx ctx = AppCtx.provideCtx();
        U.must((ctx.classes == null ? 1 : 0) != 0, (String)"The classes were already set!");
        ctx.classes = classes;
    }

    public static Classes classes() {
        AppCtx ctx = CTXS.get();
        return ctx != null ? ctx.classes : null;
    }

    public static void delClasses() {
        AppCtx ctx = AppCtx.ctx();
        ctx.classes = null;
    }
}

