/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.rapidoid.util.U;

public class Dates {
    protected static final Calendar CALENDAR = Calendar.getInstance();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private static final Date CURR_DATE = new Date();
    private static byte[] CURR_DATE_BYTES;
    private static long updateCurrDateAfter;
    private static final DateFormat DAY_FORMAT;

    public static byte[] getDateTimeBytes() {
        long time = System.currentTimeMillis();
        if (time > updateCurrDateAfter) {
            CURR_DATE.setTime(time);
            CURR_DATE_BYTES = DATE_FORMAT.format(CURR_DATE).getBytes();
            updateCurrDateAfter = time + 1000L;
        }
        return CURR_DATE_BYTES;
    }

    public static Date date(String value) {
        if (U.isEmpty((String)value)) {
            return null;
        }
        String[] parts = value.split("(\\.|-|/)");
        int a = parts.length > 0 ? U.num((String)parts[0]) : -1;
        int b = parts.length > 1 ? U.num((String)parts[1]) : -1;
        int c = parts.length > 2 ? U.num((String)parts[2]) : -1;
        switch (parts.length) {
            case 3: {
                if (Dates.isDay(a) && Dates.isMonth(b) && Dates.isYear(c)) {
                    return Dates.date(a, b, c);
                }
                if (!Dates.isYear(a) || !Dates.isMonth(b) || !Dates.isDay(c)) break;
                return Dates.date(c, b, a);
            }
            case 2: {
                if (!Dates.isDay(a) || !Dates.isMonth(b)) break;
                return Dates.date(a, b, Dates.thisYear());
            }
        }
        throw U.rte((String)("Invalid date: " + value));
    }

    private static boolean isDay(int day) {
        return day >= 1 && day <= 31;
    }

    private static boolean isMonth(int month) {
        return month >= 1 && month <= 12;
    }

    private static boolean isYear(int year) {
        return year >= 1000;
    }

    public static synchronized Date date(int day, int month, int year) {
        CALENDAR.set(year, month - 1, day, 0, 0, 0);
        return CALENDAR.getTime();
    }

    public static synchronized int thisYear() {
        CALENDAR.setTime(new Date());
        return CALENDAR.get(1);
    }

    public static String str(Date date) {
        return DAY_FORMAT.format(date);
    }

    static {
        updateCurrDateAfter = 0L;
        DAY_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

