/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import org.rapidoid.util.U;

public class IO {
    public static URL resource(String filename) {
        return IO.classLoader().getResource(filename);
    }

    public static InputStream resourceAsStream(String filename) {
        return IO.classLoader().getResourceAsStream(filename);
    }

    public static ClassLoader classLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static File file(String filename) {
        URL res;
        File file = new File(filename);
        if (!file.exists() && (res = IO.resource(filename)) != null) {
            return new File(res.getFile());
        }
        return file;
    }

    public static byte[] loadBytes(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int readN = 0;
            while ((readN = input.read(buffer)) != -1) {
                output.write(buffer, 0, readN);
            }
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        return output.toByteArray();
    }

    public static byte[] loadBytes(String filename) {
        File file;
        InputStream input = IO.classLoader().getResourceAsStream(filename);
        if (input == null && (file = new File(filename)).exists()) {
            try {
                input = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                throw U.rte((Throwable)e);
            }
        }
        return input != null ? IO.loadBytes(input) : null;
    }

    public static byte[] classBytes(String fullClassName) {
        return IO.loadBytes(fullClassName.replace('.', '/') + ".class");
    }

    public static String load(String filename) {
        byte[] bytes = IO.loadBytes(filename);
        return bytes != null ? new String(bytes) : null;
    }

    public static List<String> loadLines(String filename) {
        InputStream input = IO.classLoader().getResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        List lines = U.list((Object[])new Object[0]);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        return lines;
    }

    public static List<String> loadLines(String filename, boolean filterEmpty, String commentPrefix) {
        List<String> lines = IO.loadLines(filename);
        List lines2 = U.list((Object[])new Object[0]);
        for (String line : lines) {
            String s = line.trim();
            if (filterEmpty && s.isEmpty() || commentPrefix != null && s.startsWith(commentPrefix)) continue;
            lines2.add(s);
        }
        return lines2;
    }

    public static Map<String, String> loadMap(String filename) {
        InputStream input = IO.classLoader().getResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        Map linesMap = U.map();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split("=");
                linesMap.put(parts[0], parts[1]);
            }
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        return linesMap;
    }

    public static void save(String filename, String content) {
        IO.save(filename, content.getBytes());
    }

    public static void save(String filename, byte[] content) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename);
            out.write(content);
            IO.close(out, false);
        }
        catch (Exception e) {
            IO.close(out, true);
            throw U.rte((Throwable)e);
        }
    }

    public static void close(OutputStream out, boolean quiet) {
        block3: {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                if (quiet) break block3;
                throw U.rte((Throwable)e);
            }
        }
    }

    public static void close(InputStream in, boolean quiet) {
        block2: {
            try {
                in.close();
            }
            catch (IOException e) {
                if (quiet) break block2;
                throw U.rte((Throwable)e);
            }
        }
    }

    public static void delete(String filename) {
        new File(filename).delete();
    }

    public static MappedByteBuffer mmap(String filename, FileChannel.MapMode mode, long position, long size) {
        try {
            File file = new File(filename);
            FileChannel fc = new RandomAccessFile(file, "rw").getChannel();
            return fc.map(mode, position, size);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    public static MappedByteBuffer mmap(String filename, FileChannel.MapMode mode) {
        File file = new File(filename);
        U.must((boolean)file.exists());
        return IO.mmap(filename, mode, 0L, file.length());
    }
}

