/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.rapidoid.lambda.Lambdas;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.util.AppCtx;
import org.rapidoid.util.Classes;
import org.rapidoid.util.Cls;
import org.rapidoid.util.U;

public class Scan {
    private Scan() {
    }

    public static synchronized void args(String ... args) {
        for (String arg : args) {
            if (!arg.matches("\\+\\w+")) continue;
            Scan.addon(arg.substring(1));
        }
    }

    private static Object addon(String addonName) {
        U.must((boolean)addonName.matches("\\w+"), (String)"Invalid add-on name, must be alphanumeric!");
        String addonClassName = "org.rapidoid.addon." + U.capitalized((String)addonName) + "Addon";
        Class addonCls = Cls.getClassIfExists(addonClassName);
        if (addonCls != null) {
            if (Callable.class.isAssignableFrom(addonCls)) {
                Callable addon = (Callable)Cls.newInstance(addonCls);
                try {
                    Object addonResult = addon.call();
                    Log.info((String)"Executed add-on", (String)"add-on", (Object)addonName, (String)"add-on class", (Object)addonClassName, (String)"result", addonResult);
                    return addonResult;
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
            Log.warn((String)"Found add-on, but it's not a Runnable!", (String)"add-on", (Object)addonName, (String)"add-on class", (Object)addonClassName);
        } else {
            Log.debug((String)"No add-on was found", (String)"add-on", (Object)addonName, (String)"add-on class", (Object)addonClassName);
        }
        return null;
    }

    public static List<Class<?>> classes(String packageName, String nameRegex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        if (U.isEmpty((String)packageName) || packageName.equals("*")) {
            packageName = "";
        }
        Pattern regex = nameRegex != null ? Pattern.compile(nameRegex) : null;
        Classes ctxClasses = AppCtx.classes();
        if (ctxClasses != null) {
            return Scan.filterClasses(ctxClasses, packageName, regex, filter, annotated);
        }
        ArrayList classes = new ArrayList();
        Enumeration<URL> urls = Scan.resources(packageName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File file = new File(url.getFile());
            String path = file.getAbsolutePath();
            String pkgPath = packageName.replace('.', File.separatorChar);
            String rootPath = pkgPath.isEmpty() ? path : path.replace(File.separatorChar + pkgPath, "");
            File root = new File(rootPath);
            U.must((boolean)root.exists());
            U.must((boolean)root.isDirectory());
            Scan.getClasses(classes, root, file, regex, filter, annotated, classLoader);
        }
        return classes;
    }

    private static List<Class<?>> filterClasses(Classes classes, String packageName, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated) {
        List matching = U.list((Object[])new Object[0]);
        for (Map.Entry e : classes.entrySet()) {
            String pkg;
            Class cls = (Class)e.getValue();
            String string = pkg = cls.getPackage() != null ? cls.getPackage().getName() : "";
            if (!pkg.startsWith(packageName + ".") && !pkg.equals(packageName) || !Scan.classMatches(cls, filter, annotated, regex)) continue;
            matching.add(cls);
        }
        return matching;
    }

    public static List<Class<?>> annotated(Class<? extends Annotation> annotated) {
        return Scan.classes(null, null, null, annotated, null);
    }

    public static List<Class<?>> pkg(String packageName) {
        return Scan.classes(packageName, null, null, null, null);
    }

    public static List<Class<?>> byName(String simpleName, Predicate<Class<?>> filter, ClassLoader classLoader) {
        List<Class<?>> classes = Scan.classes("*", "(.*\\.|^)" + simpleName, filter, null, classLoader);
        return classes;
    }

    public static List<Class<?>> bySuffix(String nameSuffix, Predicate<Class<?>> filter, ClassLoader classLoader) {
        List<Class<?>> classes = Scan.classes("*", ".*\\w" + nameSuffix, filter, null, classLoader);
        return classes;
    }

    public static List<File> files(String packageName, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        Scan.files(packageName, files, filter);
        return files;
    }

    public static List<File> dir(String dir, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        Scan.getFiles(files, new File(dir), filter);
        return files;
    }

    public static void files(String packageName, Collection<File> files, Predicate<File> filter) {
        Enumeration<URL> urls = Scan.resources(packageName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File file = new File(url.getFile());
            Scan.getFiles(files, file, filter);
        }
    }

    private static void getFiles(Collection<File> files, File file, Predicate<File> filter) {
        if (file.isDirectory()) {
            Log.debug((String)"scanning directory", (String)"dir", (Object)file);
            for (File f : file.listFiles()) {
                if (f.isDirectory()) {
                    Scan.getFiles(files, f, filter);
                    continue;
                }
                Log.debug((String)"scanned file", (String)"file", (Object)f);
                try {
                    if (filter != null && !filter.eval((Object)f)) continue;
                    files.add(f);
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
        }
    }

    private static void getClasses(Collection<Class<?>> classes, File root, File parent, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        if (parent.isDirectory()) {
            Log.debug((String)"scanning directory", (String)"dir", (Object)parent);
            for (File f : parent.listFiles()) {
                if (f.isDirectory()) {
                    Scan.getClasses(classes, root, f, regex, filter, annotated, classLoader);
                    continue;
                }
                Log.debug((String)"scanned file", (String)"file", (Object)f);
                if (!f.getName().endsWith(".class")) continue;
                String clsName = f.getAbsolutePath();
                String rootPath = root.getAbsolutePath();
                U.must((boolean)clsName.startsWith(rootPath));
                clsName = clsName.substring(rootPath.length() + 1, clsName.length() - 6);
                clsName = clsName.replace(File.separatorChar, '.');
                if (regex != null && !regex.matcher(clsName).matches()) continue;
                try {
                    Class<?> cls;
                    Log.debug((String)"loading class", (String)"name", (Object)clsName);
                    Class<?> clazz = cls = classLoader != null ? Class.forName(clsName, true, classLoader) : Class.forName(clsName);
                    if (!Scan.classMatches(cls, filter, annotated, regex)) continue;
                    classes.add(cls);
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
        }
    }

    private static boolean classMatches(Class<?> cls, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, Pattern regex) {
        return !(annotated != null && cls.getAnnotation(annotated) == null || regex != null && !regex.matcher(cls.getCanonicalName()).matches() || filter != null && !Lambdas.eval(filter, cls));
    }

    private static Enumeration<URL> resources(String name) {
        if ((name = name.replace('.', '/')).equals("*")) {
            name = "";
        }
        try {
            return Cls.classLoader().getResources(name);
        }
        catch (IOException e) {
            throw U.rte((String)("Cannot scan: " + name), (Throwable)e);
        }
    }
}

