/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.security.SecureClassLoader;
import org.rapidoid.cls.Cls;
import org.rapidoid.lambda.Lambdas;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.util.U;

public class CustomizableClassLoader
extends SecureClassLoader {
    private final Mapper<String, byte[]> classes;
    private final Predicate<String> allowed;
    private boolean forceReload;

    public CustomizableClassLoader(Mapper<String, byte[]> classes, Predicate<String> allowed, boolean forceReload) {
        this.classes = classes;
        this.allowed = allowed;
        this.forceReload = forceReload;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        U.secure((boolean)Lambdas.eval(this.allowed, (Object)name), (String)"Class not allowed: %s", (Object)name);
        if (this.forceReload && !Cls.isJREClass((String)name)) {
            try {
                return this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        U.secure((boolean)Lambdas.eval(this.allowed, (Object)name), (String)"Class not allowed: %s", (Object)name);
        byte[] bytes = (byte[])Lambdas.eval(this.classes, (Object)name);
        if (bytes != null) {
            return super.defineClass(name, bytes, 0, bytes.length);
        }
        throw new ClassNotFoundException("Cannot find class: " + name);
    }
}

