/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rapidoid.cls.Cls;
import org.rapidoid.cls.TypeKind;
import org.rapidoid.lambda.F2;
import org.rapidoid.lambda.Lambdas;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.util.Bufs;
import org.rapidoid.util.Constants;
import org.rapidoid.util.D;
import org.rapidoid.util.U;

public class UTILS
implements Constants {
    private static long measureStart;
    private static final Set<String> SPECIAL_PROPERTIES;
    private static final Pattern CAMEL_SPLITTER_PATTERN;

    private UTILS() {
    }

    public static byte[] serialize(Object value) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(output);
            out.writeObject(value);
            output.close();
            return output.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object deserialize(byte[] buf) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buf));
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void serialize(Object value, ByteBuffer buf) {
        byte[] bytes = UTILS.serialize(value);
        buf.putInt(bytes.length);
        buf.put(bytes);
    }

    public static Object deserialize(ByteBuffer buf) {
        int len = buf.getInt();
        byte[] bytes = new byte[len];
        buf.get(bytes);
        return UTILS.deserialize(bytes);
    }

    public static void encode(long value, ByteBuffer buf) {
        buf.put((byte)TypeKind.LONG.ordinal());
        buf.putLong(value);
    }

    public static void encode(Object value, ByteBuffer buf) {
        TypeKind kind = Cls.kindOf((Object)value);
        int ordinal = kind.ordinal();
        assert (ordinal < 128);
        byte kindCode = (byte)ordinal;
        buf.put(kindCode);
        switch (kind) {
            case NULL: {
                break;
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                throw U.notExpected();
            }
            case STRING: {
                String str = (String)value;
                byte[] bytes = str.getBytes();
                int len = bytes.length;
                if (len < 255) {
                    buf.put(UTILS.bytee(len));
                } else {
                    buf.put(UTILS.bytee(255));
                    buf.putInt(len);
                }
                buf.put(bytes);
                break;
            }
            case BOOLEAN_OBJ: {
                boolean val = (Boolean)value;
                buf.put((byte)(val ? 1 : 0));
                break;
            }
            case BYTE_OBJ: {
                buf.put((Byte)value);
                break;
            }
            case SHORT_OBJ: {
                buf.putShort((Short)value);
                break;
            }
            case CHAR_OBJ: {
                buf.putChar(((Character)value).charValue());
                break;
            }
            case INT_OBJ: {
                buf.putInt((Integer)value);
                break;
            }
            case LONG_OBJ: {
                buf.putLong((Long)value);
                break;
            }
            case FLOAT_OBJ: {
                buf.putFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE_OBJ: {
                buf.putDouble((Double)value);
                break;
            }
            case OBJECT: {
                UTILS.serialize(value, buf);
                break;
            }
            case DATE: {
                buf.putLong(((Date)value).getTime());
                break;
            }
            default: {
                throw U.notExpected();
            }
        }
    }

    private static byte bytee(int n) {
        return (byte)(n - 128);
    }

    public static long decodeLong(ByteBuffer buf) {
        U.must((buf.get() == TypeKind.LONG.ordinal() ? 1 : 0) != 0);
        return buf.getLong();
    }

    public static Object decode(ByteBuffer buf) {
        byte kindCode = buf.get();
        TypeKind kind = TypeKind.values()[kindCode];
        switch (kind) {
            case NULL: {
                return null;
            }
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                return buf.get() != 0;
            }
            case BYTE: 
            case BYTE_OBJ: {
                return buf.get();
            }
            case SHORT: 
            case SHORT_OBJ: {
                return buf.getShort();
            }
            case CHAR: 
            case CHAR_OBJ: {
                return Character.valueOf(buf.getChar());
            }
            case INT: 
            case INT_OBJ: {
                return buf.getInt();
            }
            case LONG: 
            case LONG_OBJ: {
                return buf.getLong();
            }
            case FLOAT: 
            case FLOAT_OBJ: {
                return Float.valueOf(buf.getFloat());
            }
            case DOUBLE: 
            case DOUBLE_OBJ: {
                return buf.getDouble();
            }
            case STRING: {
                byte len = buf.get();
                int realLen = len + 128;
                if (realLen == 255) {
                    realLen = buf.getInt();
                }
                byte[] sbuf = new byte[realLen];
                buf.get(sbuf);
                return new String(sbuf);
            }
            case OBJECT: {
                return UTILS.deserialize(buf);
            }
            case DATE: {
                return new Date(buf.getLong());
            }
        }
        throw U.notExpected();
    }

    public static String stackTraceOf(Throwable e) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(output));
        return output.toString();
    }

    public static void connect(String address, int port, F2<Void, BufferedReader, DataOutputStream> protocol) {
        Socket socket = null;
        try {
            socket = new Socket(address, port);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            protocol.execute((Object)in, (Object)out);
            socket.close();
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    throw U.rte((Throwable)e);
                }
            }
        }
    }

    public static void listen(int port, F2<Void, BufferedReader, DataOutputStream> protocol) {
        UTILS.listen(null, port, protocol);
    }

    /*
     * Unable to fully structure code
     */
    public static void listen(String hostname, int port, F2<Void, BufferedReader, DataOutputStream> protocol) {
        socket = null;
        try {
            try {
                socket = new ServerSocket();
                socket.bind(U.isEmpty((String)hostname) != false ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port));
                Log.info((String)"Starting TCP/IP server", (String)"host", (Object)hostname, (String)"port", (Object)port);
                while (true) lbl-1000:
                // 3 sources

                {
                    conn = socket.accept();
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    out = new DataOutputStream(conn.getOutputStream());
                    try {
                        protocol.execute((Object)in, (Object)out);
                    }
                    catch (Exception e) {
                        throw U.rte((Throwable)e);
                    }
                    finally {
                        conn.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var9_10) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    throw U.rte((Throwable)e);
                }
            }
            throw var9_10;
        }
    }

    public static void microHttpServer(String hostname, int port, final F2<String, String, List<String>> handler) {
        UTILS.listen(hostname, port, new F2<Void, BufferedReader, DataOutputStream>(){

            public Void execute(BufferedReader in, DataOutputStream out) throws Exception {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = in.readLine()) != null && !line.isEmpty()) {
                    lines.add(line);
                }
                if (!lines.isEmpty()) {
                    String req = (String)lines.get(0);
                    if (req.startsWith("GET /")) {
                        int pos = req.indexOf(32, 4);
                        String path = UTILS.urlDecode(req.substring(4, pos));
                        String response = (String)handler.execute((Object)path, lines);
                        out.writeBytes(response);
                    } else {
                        out.writeBytes("Only GET requests are supported!");
                    }
                } else {
                    out.writeBytes("Invalid HTTP request!");
                }
                return null;
            }
        });
    }

    public static <T> void filter(Collection<T> coll, Predicate<T> predicate) {
        try {
            Iterator<T> iterator = coll.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                if (predicate.eval(t)) continue;
                iterator.remove();
            }
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    public static short bytesToShort(String s) {
        ByteBuffer buf = Bufs.buf(s);
        U.must((buf.limit() == 2 ? 1 : 0) != 0);
        return buf.getShort();
    }

    public static int bytesToInt(String s) {
        ByteBuffer buf = Bufs.buf(s);
        U.must((buf.limit() == 4 ? 1 : 0) != 0);
        return buf.getInt();
    }

    public static long bytesToLong(String s) {
        ByteBuffer buf = Bufs.buf(s);
        U.must((buf.limit() == 8 ? 1 : 0) != 0);
        return buf.getLong();
    }

    public static int intFrom(byte a, byte b, byte c, byte d) {
        return (a << 24) + (b << 16) + (c << 8) + d;
    }

    public static short shortFrom(byte a, byte b) {
        return (short)((a << 8) + b);
    }

    public static <K, V> Map<K, V> autoExpandingMap(final Class<V> clazz) {
        return UTILS.autoExpandingMap(new Mapper<K, V>(){

            public V map(K src) throws Exception {
                return Cls.newInstance((Class)clazz);
            }
        });
    }

    public static <K, V> Map<K, V> autoExpandingMap(final Mapper<K, V> valueFactory) {
        return new ConcurrentHashMap<K, V>(){

            @Override
            public synchronized V get(Object key) {
                Object val = super.get(key);
                if (val == null) {
                    try {
                        val = valueFactory.map(key);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.put(key, val);
                }
                return val;
            }
        };
    }

    public static String replace(String s, String regex, Mapper<String[], String> replacer) {
        StringBuffer output = new StringBuffer();
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(s);
        while (matcher.find()) {
            int len = matcher.groupCount() + 1;
            String[] gr = new String[len];
            for (int i = 0; i < gr.length; ++i) {
                gr[i] = matcher.group(i);
            }
            matcher.appendReplacement(output, (String)Lambdas.eval(replacer, (Object)gr));
        }
        matcher.appendTail(output);
        return output.toString();
    }

    public static boolean waitInterruption(long millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(Object obj) {
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void joinThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Object[] flat(Object ... arr) {
        List flat = U.list((Object[])new Object[0]);
        UTILS.flatInsertInto(flat, 0, arr);
        return flat.toArray();
    }

    public static <T> int flatInsertInto(List<T> dest, int index, Object item) {
        if (index > dest.size()) {
            index = dest.size();
        }
        int inserted = 0;
        if (item instanceof Object[]) {
            Object[] arr;
            for (Object obj : arr = (Object[])item) {
                inserted += UTILS.flatInsertInto(dest, index + inserted, obj);
            }
        } else if (item instanceof Collection) {
            Collection coll = (Collection)item;
            for (Object obj : coll) {
                inserted += UTILS.flatInsertInto(dest, index + inserted, obj);
            }
        } else if (item != null) {
            if (index >= dest.size()) {
                dest.add(item);
            } else {
                dest.add(index + inserted, item);
            }
            ++inserted;
        }
        return inserted;
    }

    public static void benchmark(String name, int count, Runnable runnable) {
        long start = U.time();
        for (int i = 0; i < count; ++i) {
            runnable.run();
        }
        UTILS.benchmarkComplete(name, count, start);
    }

    public static void benchmarkComplete(String name, int count, long startTime) {
        double avg;
        long end = U.time();
        long ms = end - startTime;
        if (ms == 0L) {
            ms = 1L;
        }
        String avgs = (avg = (double)count / (double)ms) > 1.0 ? Math.round(avg) + "K" : Math.round(avg * 1000.0) + "";
        String data = String.format("%s: %s in %s ms (%s/sec)", name, count, ms, avgs);
        System.out.println(data + " | " + UTILS.getCpuMemStats());
    }

    public static void benchmarkMT(int threadsN, final String name, int count, final CountDownLatch outsideLatch, final Runnable runnable) {
        final int countPerThread = count / threadsN;
        final CountDownLatch latch = outsideLatch != null ? outsideLatch : new CountDownLatch(threadsN);
        long time = U.time();
        for (int i = 1; i <= threadsN; ++i) {
            new Thread(){

                @Override
                public void run() {
                    UTILS.benchmark(name, countPerThread, runnable);
                    if (outsideLatch == null) {
                        latch.countDown();
                    }
                }
            }.start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw U.rte((Throwable)e);
        }
        UTILS.benchmarkComplete("avg(" + name + ")", threadsN * countPerThread, time);
    }

    public static void benchmarkMT(int threadsN, String name, int count, Runnable runnable) {
        UTILS.benchmarkMT(threadsN, name, count, null, runnable);
    }

    public static String getCpuMemStats() {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long maxMem = rt.maxMemory();
        long freeMem = rt.freeMemory();
        long usedMem = totalMem - freeMem;
        int megs = 0x100000;
        String msg = "MEM [total=%s MB, used=%s MB, max=%s MB]";
        return String.format(msg, totalMem / (long)megs, usedMem / (long)megs, maxMem / (long)megs);
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw U.rte((Throwable)e);
        }
    }

    public static void startMeasure() {
        measureStart = U.time();
    }

    public static void endMeasure() {
        long delta = U.time() - measureStart;
        D.print(delta + " ms");
    }

    public static void endMeasure(String info) {
        long delta = U.time() - measureStart;
        D.print(info + ": " + delta + " ms");
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new ThreadDeath();
        }
    }

    public static Throwable rootCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static String fillIn(String template, String placeholder, String value) {
        return template.replace("{{" + placeholder + "}}", value);
    }

    public static String camelSplit(String s) {
        return CAMEL_SPLITTER_PATTERN.matcher(s).replaceAll(" ");
    }

    public static String camelPhrase(String s) {
        return U.capitalized((String)UTILS.camelSplit(s).toLowerCase());
    }

    public static <T, V extends T> List<T> withoutNulls(V ... values) {
        List list = U.list((Object[])new Object[0]);
        for (V val : values) {
            if (val == null) continue;
            list.add(val);
        }
        return list;
    }

    public static boolean isSpecialProperty(String name) {
        return SPECIAL_PROPERTIES.contains(name.toLowerCase());
    }

    public static <T> Map<String, T> lowercase(Map<String, T> map) {
        Map lower = U.map();
        for (Map.Entry<String, T> e : map.entrySet()) {
            Object val = e.getValue();
            if (val instanceof String) {
                val = ((String)val).toLowerCase();
            }
            lower.put(e.getKey().toLowerCase(), val);
        }
        return lower;
    }

    public static void multiThreaded(int threadsN, final Mapper<Integer, Void> executable) {
        final CountDownLatch latch = new CountDownLatch(threadsN);
        for (int i = 1; i <= threadsN; ++i) {
            final Integer n = i;
            new Thread(){

                @Override
                public void run() {
                    Lambdas.eval((Mapper)executable, (Object)n);
                    latch.countDown();
                }
            }.start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void multiThreaded(int threadsN, final Runnable executable) {
        UTILS.multiThreaded(threadsN, new Mapper<Integer, Void>(){

            public Void map(Integer n) throws Exception {
                executable.run();
                return null;
            }
        });
    }

    public static String path(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (U.isEmpty((String)(part = part.replaceAll("^/", "").replaceAll("/$", "")))) continue;
            UTILS.append(sb, "/", part);
        }
        return sb.toString();
    }

    public static void append(StringBuilder sb, String separator, String value) {
        if (sb.length() > 0) {
            sb.append(separator);
        }
        sb.append(value);
    }

    public static <T extends Serializable> T serializable(Object value) {
        if (value == null || value instanceof Serializable) {
            return (T)((Serializable)value);
        }
        throw U.rte((String)("Not serializable: " + value));
    }

    public static <K, V> Map<K, V> cast(Map<?, ?> map) {
        return map;
    }

    static {
        SPECIAL_PROPERTIES = U.set((Object[])new String[]{"id", "version", "createdby", "createdon", "lastupdatedby", "lastupdatedon"});
        CAMEL_SPLITTER_PATTERN = Pattern.compile("(?<=[A-Z])(?=[A-Z][a-z])|(?<=[^A-Z])(?=[A-Z])|(?<=[A-Za-z])(?=[^A-Za-z])");
    }
}

