/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.boulderdash;

import org.refcodes.boulderdash.Amoeba;
import org.refcodes.boulderdash.Boulder;
import org.refcodes.boulderdash.BoulderDashPlayer;
import org.refcodes.boulderdash.BoulderDashPlayerFactory;
import org.refcodes.boulderdash.BrickWall;
import org.refcodes.boulderdash.Butterfly;
import org.refcodes.boulderdash.Diamond;
import org.refcodes.boulderdash.Dirt;
import org.refcodes.boulderdash.ExpandingWall;
import org.refcodes.boulderdash.Firefly;
import org.refcodes.boulderdash.MagicWall;
import org.refcodes.boulderdash.Rockford;
import org.refcodes.boulderdash.SteelWall;
import org.refcodes.data.ext.boulderdash.BoulderDashStatus;
import org.refcodes.exception.BugException;

public class BoulderDashPlayerFactoryImpl
implements BoulderDashPlayerFactory {
    public BoulderDashPlayer createInstance(BoulderDashStatus aIdentifier) {
        switch (aIdentifier) {
            case AMOEBA: {
                return new Amoeba();
            }
            case BOULDER: {
                return new Boulder();
            }
            case BRICK_WALL: {
                return new BrickWall();
            }
            case BUTTERFLY: {
                return new Butterfly();
            }
            case DIAMOND: {
                return new Diamond();
            }
            case DIAMOND_BIRTH: {
                return new Diamond(BoulderDashStatus.DIAMOND_BIRTH);
            }
            case DIRT: {
                return new Dirt();
            }
            case EXPANDING_WALL: {
                return new ExpandingWall();
            }
            case FIREFLY: {
                return new Firefly();
            }
            case MAGIC_WALL: {
                return new MagicWall();
            }
            case MAGIC_WALL_EXPIRED: {
                return new MagicWall(BoulderDashStatus.MAGIC_WALL_EXPIRED);
            }
            case NONE: {
                return null;
            }
            case ROCKFORD: {
                return new Rockford();
            }
            case ROCKFORD_BIRTH: {
                return new Rockford(BoulderDashStatus.ROCKFORD_BIRTH);
            }
            case ROCKFORD_BLINKING: {
                return new Rockford(BoulderDashStatus.ROCKFORD_BLINKING);
            }
            case ROCKFORD_BLINKING_TRAPPING_FOOT: {
                return new Rockford(BoulderDashStatus.ROCKFORD_TRAPPING_FOOT);
            }
            case ROCKFORD_LEFT: {
                return new Rockford(BoulderDashStatus.ROCKFORD_LEFT);
            }
            case ROCKFORD_RIGHT: {
                return new Rockford(BoulderDashStatus.ROCKFORD_RIGHT);
            }
            case ROCKFORD_TRAPPING_FOOT: {
                return new Rockford(BoulderDashStatus.ROCKFORD_TRAPPING_FOOT);
            }
            case STEEL_WALL: {
                return new SteelWall();
            }
            case STEEL_WALL_BLINKING: {
                return new SteelWall(BoulderDashStatus.STEEL_WALL_BLINKING);
            }
            case STEEL_WALL_OPEN: {
                return new SteelWall(BoulderDashStatus.STEEL_WALL_OPEN);
            }
        }
        throw new BugException("Missing case statement for <" + aIdentifier + "> in implementation!");
    }
}

