/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.operator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FloatNode;
import org.matheclipse.parser.client.ast.FractionNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.IParserFactory;
import org.matheclipse.parser.client.ast.IntegerNode;
import org.matheclipse.parser.client.ast.PatternNode;
import org.matheclipse.parser.client.ast.StringNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.matheclipse.parser.client.operator.DivideOperator;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PreMinusOperator;
import org.matheclipse.parser.client.operator.PrePlusOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;
import org.matheclipse.parser.client.operator.SubtractOperator;

public class ASTNodeFactory
implements IParserFactory {
    public static final int PLUS_PRECEDENCE = 2900;
    public static final int TIMES_PRECEDENCE = 3800;
    public static final int POWER_PRECEDENCE = 5700;
    static final String[] HEADER_STRINGS = new String[]{"MapAll", "TimesBy", "Plus", "UpSet", "CompoundExpression", "Map", "Unset", "Apply", "ReplaceRepeated", "Less", "And", "Divide", "Set", "Increment", "Factorial2", "LessEqual", "NonCommutativeMultiply", "Factorial", "Times", "Power", "Dot", "Not", "PreMinus", "SameQ", "RuleDelayed", "GreaterEqual", "Condition", "Colon", "DivideBy", "Or", "Equal", "StringJoin", "Unequal", "Decrement", "SubtractFrom", "PrePlus", "UnsameQ", "Rule", "UpSetDelayed", "PreIncrement", "Function", "Greater", "PreDecrement", "Subtract", "SetDelayed", "Alternatives", "AddTo", "ReplaceAll"};
    static final String[] OPERATOR_STRINGS = new String[]{"//@", "*=", "+", "^=", ";", "/@", "=.", "@@", "//.", "<", "&&", "/", "=", "++", "!!", "<=", "**", "!", "*", "^", ".", "!", "-", "===", ":>", ">=", "/;", ":", "/=", "||", "==", "<>", "!=", "--", "-=", "+", "=!=", "->", "^;=", "++", "&", ">", "--", "-", ":=", "|", "+=", "/."};
    static final Operator[] OPERATORS = new Operator[]{new InfixOperator("//@", "MapAll", 6100, 1), new InfixOperator("*=", "TimesBy", 900, 0), new InfixOperator("+", "Plus", 2900, 0), new InfixOperator("^=", "UpSet", 300, 0), new InfixOperator(";", "CompoundExpression", 100, 0), new InfixOperator("/@", "Map", 6100, 1), new PostfixOperator("=.", "Unset", 300), new InfixOperator("@@", "Apply", 6100, 1), new InfixOperator("//.", "ReplaceRepeated", 1000, 2), new InfixOperator("&lt;", "Less", 2600, 0), new InfixOperator("&&", "And", 2000, 0), new DivideOperator("/", "Divide", 4500, 2), new InfixOperator("=", "Set", 300, 1), new PostfixOperator("++", "Increment", 6400), new PostfixOperator("!!", "Factorial2", 6000), new InfixOperator("&lt;=", "LessEqual", 2600, 0), new InfixOperator("**", "NonCommutativeMultiply", 5000, 0), new PostfixOperator("!", "Factorial", 6000), new InfixOperator("*", "Times", 3800, 0), new InfixOperator("^", "Power", 5700, 1), new InfixOperator(".", "Dot", 4700, 0), new PrefixOperator("!", "Not", 2100), new PreMinusOperator("-", "PreMinus", 4600), new InfixOperator("===", "SameQ", 2400, 0), new InfixOperator(":>", "RuleDelayed", 1100, 1), new InfixOperator("&gt;=", "GreaterEqual", 2600, 0), new InfixOperator("/;", "Condition", 1200, 2), new InfixOperator(":", "Colon", 700, 0), new InfixOperator("/=", "DivideBy", 900, 0), new InfixOperator("||", "Or", 1900, 0), new InfixOperator("==", "Equal", 2600, 0), new InfixOperator("&lt;>", "StringJoin", 5800, 0), new InfixOperator("!=", "Unequal", 2600, 0), new PostfixOperator("--", "Decrement", 6400), new InfixOperator("-=", "SubtractFrom", 900, 0), new PrePlusOperator("+", "PrePlus", 4600), new InfixOperator("=!=", "UnsameQ", 2400, 0), new InfixOperator("->", "Rule", 1100, 1), new InfixOperator("^;=", "UpSetDelayed", 300, 0), new PrefixOperator("++", "PreIncrement", 6400), new PostfixOperator("&", "Function", 800), new InfixOperator("&gt;", "Greater", 2600, 0), new PrefixOperator("--", "PreDecrement", 6400), new SubtractOperator("-", "Subtract", 2900, 2), new InfixOperator(":=", "SetDelayed", 300, 0), new InfixOperator("|", "Alternatives", 1400, 0), new InfixOperator("+=", "AddTo", 900, 0), new InfixOperator("/.", "ReplaceAll", 1000, 2)};
    public static final ASTNodeFactory MMA_STYLE_FACTORY = new ASTNodeFactory();
    private static HashMap<String, Operator> fOperatorMap = new HashMap();
    private static HashMap<String, ArrayList<Operator>> fOperatorTokenStartSet = new HashMap();

    public static void addOperator(Map<String, Operator> operatorMap, Map<String, ArrayList<Operator>> operatorTokenStartSet, String operatorStr, String headStr, Operator oper) {
        operatorMap.put(headStr, oper);
        ArrayList<Operator> list = operatorTokenStartSet.get(operatorStr);
        if (list == null) {
            list = new ArrayList(2);
            list.add(oper);
            operatorTokenStartSet.put(operatorStr, list);
        } else {
            list.add(oper);
        }
    }

    @Override
    public String getOperatorCharacters() {
        return ".-:=<>*+;!^|&/@";
    }

    @Override
    public Map<String, Operator> getIdentifier2OperatorMap() {
        return fOperatorMap;
    }

    @Override
    public Operator get(String identifier) {
        return fOperatorMap.get(identifier);
    }

    @Override
    public Map<String, ArrayList<Operator>> getOperator2ListMap() {
        return fOperatorTokenStartSet;
    }

    @Override
    public List<Operator> getOperatorList(String key) {
        return fOperatorTokenStartSet.get(key);
    }

    public static InfixOperator createInfixOperator(String operatorStr, String headStr, int precedence, int grouping) {
        InfixOperator oper = headStr.equals("Divide") ? new DivideOperator(operatorStr, headStr, precedence, grouping) : (headStr.equals("Subtract") ? new SubtractOperator(operatorStr, headStr, precedence, grouping) : new InfixOperator(operatorStr, headStr, precedence, grouping));
        return oper;
    }

    public static PrefixOperator createPrefixOperator(String operatorStr, String headStr, int precedence) {
        PrefixOperator oper = headStr.equals("PreMinus") ? new PreMinusOperator(operatorStr, headStr, precedence) : (headStr.equals("PrePlus") ? new PrePlusOperator(operatorStr, headStr, precedence) : new PrefixOperator(operatorStr, headStr, precedence));
        return oper;
    }

    public static PostfixOperator createPostfixOperator(String operatorStr, String headStr, int precedence) {
        return new PostfixOperator(operatorStr, headStr, precedence);
    }

    @Override
    public ASTNode createDouble(String doubleString) {
        return new FloatNode(doubleString);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head) {
        return new FunctionNode(head);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head, ASTNode arg0) {
        return new FunctionNode(head, arg0);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head, ASTNode arg0, ASTNode arg1) {
        return new FunctionNode(head, arg0, arg1);
    }

    @Override
    public FunctionNode createAST(ASTNode headExpr) {
        return new FunctionNode(headExpr);
    }

    @Override
    public IntegerNode createInteger(String integerString, int numberFormat) {
        return new IntegerNode(integerString, numberFormat);
    }

    @Override
    public IntegerNode createInteger(int intValue) {
        return new IntegerNode(intValue);
    }

    @Override
    public FractionNode createFraction(IntegerNode numerator, IntegerNode denominator) {
        return new FractionNode(numerator, denominator);
    }

    @Override
    public PatternNode createPattern(SymbolNode patternName, ASTNode check) {
        return new PatternNode(patternName, check);
    }

    @Override
    public StringNode createString(StringBuffer buffer) {
        return new StringNode(buffer.toString());
    }

    @Override
    public SymbolNode createSymbol(String symbolName) {
        return new SymbolNode(symbolName);
    }

    @Override
    public boolean isValidIdentifier(String identifier) {
        return true;
    }

    static {
        for (int i = 0; i < HEADER_STRINGS.length; ++i) {
            ASTNodeFactory.addOperator(fOperatorMap, fOperatorTokenStartSet, OPERATOR_STRINGS[i], HEADER_STRINGS[i], OPERATORS[i]);
        }
    }
}

