/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.AbstractCheckerboardViewer;
import org.refcodes.checkerboard.BackgroundFactory;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.GraphicalCheckerboardViewer;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.SpriteFactory;
import org.refcodes.component.InitializeException;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.ScaleMode;
import org.refcodes.observer.UnsubscribeEvent;

public abstract class AbstractGraphicalCheckerboardViewer<P extends Player<P, S>, S, IMG, SF extends SpriteFactory<IMG, S, ?>, BF extends BackgroundFactory<IMG, CBV>, CBV extends GraphicalCheckerboardViewer<P, S, IMG, SF, BF, CBV>>
extends AbstractCheckerboardViewer<P, S, IMG, SF, CBV>
implements GraphicalCheckerboardViewer<P, S, IMG, SF, BF, CBV> {
    private int _fieldHeight = -1;
    private int _fieldWidth = -1;
    private int _fieldGap = 0;
    private MoveMode _moveMode = MoveMode.SMOOTH;
    private ScaleMode _scaleMode = ScaleMode.SCALE_GRID;
    private SF _spriteFactory = null;
    private BF _backgroundFactory = null;

    @Override
    public int getFieldGap() {
        return this._fieldGap;
    }

    @Override
    public void setFieldGap(int aFieldGap) {
        this._fieldGap = aFieldGap;
    }

    @Override
    public CBV withFieldGap(int aFieldGap) {
        this.setFieldGap(aFieldGap);
        return (CBV)this;
    }

    @Override
    public void show() {
        this.setVisible(true);
    }

    @Override
    public void hide() {
        this.setVisible(false);
    }

    @Override
    public MoveMode getMoveMode() {
        return this._moveMode;
    }

    @Override
    public void setMoveMode(MoveMode aMode) {
        this._moveMode = aMode;
    }

    @Override
    public ScaleMode getScaleMode() {
        return this._scaleMode;
    }

    @Override
    public void setScaleMode(ScaleMode aMode) {
        this._scaleMode = aMode;
    }

    @Override
    public int getFieldHeight() {
        return this._fieldHeight;
    }

    @Override
    public void setFieldDimension(int aFieldWidth, int aFieldHeight) {
        this._fieldWidth = aFieldWidth;
        this._fieldHeight = aFieldHeight;
    }

    @Override
    public void setFieldDimension(FieldDimension aField) {
        this.setFieldDimension(aField.getFieldWidth(), aField.getFieldHeight());
    }

    @Override
    public void setFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    @Override
    public void setFieldWidth(int aWidth) {
        this.setFieldDimension(aWidth, this._fieldHeight);
    }

    @Override
    public int getFieldWidth() {
        return this._fieldWidth;
    }

    @Override
    public void setFieldHeight(int aHeight) {
        this.setFieldDimension(this._fieldWidth, aHeight);
    }

    @Override
    public int getContainerHeight() {
        return this.getFieldHeight() * this.getViewportHeight() + this.getFieldGap() * (this.getViewportHeight() - 1) + (this.getCheckerboard().getGridMode() == GridMode.CLOSED ? this.getFieldGap() * 2 : 0);
    }

    @Override
    public int getContainerWidth() {
        return this.getFieldWidth() * this.getViewportWidth() + this.getFieldGap() * (this.getViewportWidth() - 1) + (this.getCheckerboard().getGridMode() == GridMode.CLOSED ? this.getFieldGap() * 2 : 0);
    }

    @Override
    public CBV withFieldWidth(int aWidth) {
        this.setFieldWidth(aWidth);
        return (CBV)this;
    }

    @Override
    public CBV withFieldHeight(int aHeight) {
        this.setFieldHeight(aHeight);
        return (CBV)this;
    }

    @Override
    public CBV withFieldDimension(FieldDimension aField) {
        this.setFieldDimension(aField);
        return (CBV)this;
    }

    @Override
    public CBV withFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension);
        return (CBV)this;
    }

    @Override
    public CBV withInitialize() throws InitializeException {
        this.initialize();
        return (CBV)this;
    }

    @Override
    public CBV withShow() {
        this.setVisible(true);
        return (CBV)this;
    }

    @Override
    public CBV withHide() {
        this.setVisible(false);
        return (CBV)this;
    }

    @Override
    public CBV withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return (CBV)this;
    }

    @Override
    public CBV withMoveMode(MoveMode aMode) {
        this.setMoveMode(aMode);
        return (CBV)this;
    }

    @Override
    public CBV withScaleMode(ScaleMode aMode) {
        this.setScaleMode(aMode);
        return (CBV)this;
    }

    @Override
    public int toTotalWidth() {
        int theTotalWidth = this.getFieldWidth() * this.getViewportWidth() + this.getFieldGap() * (this.getViewportWidth() - 1);
        if (this.getGridMode() == GridMode.CLOSED) {
            theTotalWidth += this.getFieldGap() * 2;
        }
        return theTotalWidth;
    }

    @Override
    public void setFieldDimension(int aFieldWidth, int aFieldHeight, int aGap) {
        this.setFieldDimension(aFieldWidth, aFieldHeight);
        this.setFieldGap(aGap);
    }

    @Override
    public CBV withFieldDimension(int aFieldWidth, int aFieldHeight, int aGap) {
        this.setFieldDimension(aFieldWidth, aFieldHeight, aGap);
        return (CBV)this;
    }

    @Override
    public int toTotalHeight() {
        int theTotalHeight = this.getFieldHeight() * this.getViewportHeight() + this.getFieldGap() * (this.getViewportHeight() - 1);
        if (this.getGridMode() == GridMode.CLOSED) {
            theTotalHeight += this.getFieldGap() * 2;
        }
        return theTotalHeight;
    }

    @Override
    public CBV withFieldDimension(int aFieldWidth, int aFieldHeight) {
        this.setFieldDimension(aFieldWidth, aFieldHeight);
        return (CBV)this;
    }

    @Override
    public void setSpriteFactory(SF aSpriteFactory) {
        this._spriteFactory = aSpriteFactory;
    }

    @Override
    public SF getSpriteFactory() {
        return this._spriteFactory;
    }

    @Override
    public CBV withSpriteFactory(SF aSpriteFactory) {
        this.setSpriteFactory(aSpriteFactory);
        return (CBV)this;
    }

    @Override
    public CBV withBackgroundFactory(BF aBackgroundFactory) {
        this.setBackgroundFactory(aBackgroundFactory);
        return (CBV)this;
    }

    @Override
    public void setBackgroundFactory(BF aBackgroundFactory) {
        this._backgroundFactory = aBackgroundFactory;
    }

    @Override
    public BF getBackgroundFactory() {
        return this._backgroundFactory;
    }

    @Override
    public void onUnsubscribe(UnsubscribeEvent<Checkerboard<P, S>> aUnsubscribeEvent) {
    }

    @Override
    protected Checkerboard<P, S> getCheckerboard() {
        return super.getCheckerboard();
    }
}

