/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.AbstractPlayerEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PositionChangedEvent;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.PositionImpl;

public class PositionChangedEventImpl<P extends Player<P, ?>>
extends AbstractPlayerEvent<P>
implements PositionChangedEvent<P> {
    private int _posX;
    private int _posY;
    private Position _precedingPosition;

    public PositionChangedEventImpl(int aPosX, int aPosY, int aPrePosX, int aPrePosY, P aSource) {
        super(ACTION, aSource);
        this._posX = aPosX;
        this._posY = aPosY;
        this._precedingPosition = new PositionImpl(aPrePosX, aPrePosY);
    }

    public PositionChangedEventImpl(Position aPosition, Position aPrecedingPosition, P aSource) {
        super(ACTION, aSource);
        this._posX = aPosition.getPositionX();
        this._posY = aPosition.getPositionY();
        this._precedingPosition = aPrecedingPosition;
    }

    @Override
    public Position getPrecedingPosition() {
        return this._precedingPosition;
    }

    @Override
    public int getPositionX() {
        return this._posX;
    }

    @Override
    public int getPositionY() {
        return this._posY;
    }

    @Override
    public int getVectorX() {
        return this._posX - this._precedingPosition.getPositionX();
    }

    @Override
    public int getVectorY() {
        return this._posY - this._precedingPosition.getPositionY();
    }

    @Override
    public String toString() {
        return super.toString() + ", x := " + this._posX + ", y := " + this._posY + " (state before: " + this._precedingPosition + ")";
    }
}

