/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectableComponent;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.controlflow.ControlFlowUtility;

public abstract class AbstractConnectableAutomaton
implements ConnectableComponent.ConnectableAutomaton {
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    @Override
    public boolean isOpened() {
        return this._connectionStatus == ConnectionStatus.OPENED;
    }

    @Override
    public boolean isClosable() {
        return this._connectionStatus == ConnectionStatus.OPENED;
    }

    @Override
    public void close() throws CloseException {
        ControlFlowUtility.throwIllegalStateException(!this.isOpened());
        this.setConnectionStatus(ConnectionStatus.CLOSED);
    }

    @Override
    public boolean isClosed() {
        return this._connectionStatus == ConnectionStatus.CLOSED;
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    protected boolean isOpenable() {
        return !this.isOpened();
    }

    protected void open() throws OpenException {
        if (this.isOpened()) {
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + (Object)((Object)this.getConnectionStatus()) + ".");
        }
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    protected void setConnectionStatus(ConnectionStatus aConnectionStatus) {
        this._connectionStatus = aConnectionStatus;
    }
}

