/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import java.io.Flushable;
import java.util.Timer;
import java.util.TimerTask;
import org.refcodes.component.CloseException;
import org.refcodes.component.ClosedAccessor;
import org.refcodes.controlflow.RetryTimeoutImpl;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.IoTimeout;
import org.refcodes.exception.HiddenException;

public interface Closable {
    public void close() throws CloseException;

    default public void closeUnchecked() {
        try {
            this.close();
        }
        catch (CloseException e) {
            throw new HiddenException(e);
        }
    }

    default public void closeQuietly() {
        if (this instanceof Flushable) {
            try {
                ((Flushable)((Object)this)).flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl((long)IoTimeout.NORM.getMilliseconds(), IoRetryCount.NORM.getNumber());
        while (theRetryTimeout.hasNextRetry()) {
            try {
                this.close();
                return;
            }
            catch (CloseException closeException) {
            }
        }
    }

    default public void closeIn(int aCloseInMillis) {
        final Timer theTimer = new Timer();
        theTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    Closable.this.close();
                }
                catch (CloseException e) {
                    throw new HiddenException(e);
                }
                finally {
                    theTimer.cancel();
                }
            }
        }, aCloseInMillis);
    }

    public static interface CloseAutomaton
    extends Closable,
    ClosedAccessor {
        public boolean isClosable();
    }

    public static interface CloseBuilder<B extends CloseBuilder<B>> {
        public B withClose() throws CloseException;

        public B withCloseQuietly();

        public B withCloseIn(int var1);

        default public B withCloseUnchecked() {
            try {
                return this.withClose();
            }
            catch (CloseException e) {
                throw new HiddenException(e);
            }
        }
    }
}

