/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.LinkComponent;
import org.refcodes.component.OpenException;

public class DeviceAutomatonImpl
implements LinkComponent.LinkAutomaton {
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;
    protected LinkComponent _connectionComponent = null;

    public DeviceAutomatonImpl() {
    }

    public DeviceAutomatonImpl(LinkComponent aConnectionComponent) {
        this._connectionComponent = aConnectionComponent;
    }

    @Override
    public synchronized ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    @Override
    public boolean isOpenable() {
        return this._connectionStatus == ConnectionStatus.NONE || this.isClosed();
    }

    @Override
    public void open() throws OpenException {
        if (!this.isOpenable()) {
            throw new OpenException("Cannot open as the component is in status <" + (Object)((Object)this._connectionStatus) + "> which is not the appropriate status for opening.");
        }
        if (this._connectionComponent != null) {
            this._connectionComponent.open();
        }
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    @Override
    public boolean isOpened() {
        return this._connectionStatus == ConnectionStatus.OPENED;
    }

    @Override
    public boolean isClosable() {
        return this._connectionStatus == ConnectionStatus.OPENED;
    }

    @Override
    public boolean isClosed() {
        return this._connectionStatus == ConnectionStatus.CLOSED;
    }

    @Override
    public void close() {
        if (this.isOpened()) {
            try {
                if (this._connectionComponent != null) {
                    this._connectionComponent.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._connectionStatus = ConnectionStatus.CLOSED;
    }
}

