/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.criteria;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.refcodes.criteria.ComplexCriteriaException;
import org.refcodes.criteria.Criteria;
import org.refcodes.criteria.CriteriaLeaf;
import org.refcodes.criteria.CriteriaNode;
import org.refcodes.criteria.EqualWithCriteria;
import org.refcodes.criteria.NotCriteria;
import org.refcodes.exception.HiddenException;

public final class CriteriaUtility {
    private CriteriaUtility() {
    }

    public static <P> Set<P> getPartitions(Criteria aCriteria, String aKey, Class<P> aType) {
        HashSet thePartitions = new HashSet();
        HashSet<Criteria> theVistedCriteria = new HashSet<Criteria>();
        try {
            CriteriaUtility.getPartitions(thePartitions, aCriteria, aKey, aType, false, theVistedCriteria);
        }
        catch (ComplexCriteriaException e) {
            thePartitions.clear();
            throw new HiddenException(e);
        }
        theVistedCriteria.clear();
        return thePartitions;
    }

    private static <C> void getPartitions(Set<C> aPartitions, Criteria aCriteria, String aKey, Class<C> aType, boolean isNotBranch, Set<Criteria> aVistedCriterias) throws ComplexCriteriaException {
        if (!aVistedCriterias.contains(aCriteria)) {
            CriteriaLeaf theCriteriaLeaf;
            aVistedCriterias.add(aCriteria);
            if (aCriteria instanceof CriteriaNode) {
                CriteriaNode theCriteriaNode = (CriteriaNode)aCriteria;
                isNotBranch |= theCriteriaNode instanceof NotCriteria;
                List<Criteria> theChildCriterias = theCriteriaNode.getChildren();
                for (Criteria eChildCriteria : theChildCriterias) {
                    CriteriaUtility.getPartitions(aPartitions, eChildCriteria, aKey, aType, isNotBranch, aVistedCriterias);
                }
            } else if (aCriteria instanceof CriteriaLeaf && (theCriteriaLeaf = (CriteriaLeaf)aCriteria).getKey() != null && theCriteriaLeaf.getValue() != null && ((String)theCriteriaLeaf.getKey()).equals(aKey) && aType.isAssignableFrom(theCriteriaLeaf.getValue().getClass())) {
                if (isNotBranch || !(theCriteriaLeaf instanceof EqualWithCriteria)) {
                    throw new ComplexCriteriaException(aCriteria, "The provided criteria is too complex in order to determin the set of relevant partitions! Either the partition key \"" + aKey + "\" with type <" + aType.getName() + "> is contained inside a NOT node's child or included in a criteria different from an EQUALS criteria leaf!");
                }
                aPartitions.add(theCriteriaLeaf.getValue());
            }
        }
    }

    public static <C> Criteria doRemovePartitionCriteria(Criteria aCriteria, String aKey, Set<C> aPartitions) {
        if (aPartitions == null || aPartitions.isEmpty()) {
            return aCriteria;
        }
        HashSet<Criteria> theVistedCriteria = new HashSet<Criteria>();
        Criteria theCriteria = CriteriaUtility.doRemovePartitionCriteria(aCriteria, aKey, aPartitions, theVistedCriteria);
        theVistedCriteria.clear();
        return theCriteria;
    }

    private static <C> Criteria doRemovePartitionCriteria(Criteria aCriteria, String aKey, Set<C> aPartitions, Set<Criteria> aVistedCriterias) {
        CriteriaLeaf theCriteriaLeaf;
        if (aVistedCriterias.contains(aCriteria)) {
            return null;
        }
        aVistedCriterias.add(aCriteria);
        if (aCriteria instanceof CriteriaNode) {
            CriteriaNode theCriteriaNode = (CriteriaNode)aCriteria;
            ArrayList<Criteria> theChildCriterias = new ArrayList<Criteria>(theCriteriaNode.getChildren());
            for (Criteria eChildCriteria : theChildCriterias) {
                int eIndex;
                CriteriaLeaf eCriteriaLeaf;
                if (eChildCriteria instanceof CriteriaLeaf && (eCriteriaLeaf = (CriteriaLeaf)eChildCriteria).getKey() != null && eCriteriaLeaf.getValue() != null && ((String)eCriteriaLeaf.getKey()).equals(aKey) && aPartitions.contains(eCriteriaLeaf.getValue())) {
                    theCriteriaNode.getChildren().remove(eCriteriaLeaf);
                }
                if (!(eChildCriteria instanceof CriteriaNode)) continue;
                Criteria eResultCriteria = CriteriaUtility.doRemovePartitionCriteria(eChildCriteria, aKey, aPartitions, aVistedCriterias);
                if (eResultCriteria == null) {
                    theCriteriaNode.getChildren().remove(eChildCriteria);
                    continue;
                }
                if (eResultCriteria == eChildCriteria || (eIndex = theCriteriaNode.getChildren().indexOf(eChildCriteria)) == -1) continue;
                theCriteriaNode.getChildren().remove(eIndex);
                theCriteriaNode.getChildren().add(eIndex, eResultCriteria);
            }
            if (theCriteriaNode.getChildren().size() == 1) {
                return theCriteriaNode.getChildren().get(0);
            }
            if (theCriteriaNode.getChildren().size() == 0) {
                return null;
            }
        } else if (aCriteria instanceof CriteriaLeaf && (theCriteriaLeaf = (CriteriaLeaf)aCriteria).getKey() != null && theCriteriaLeaf.getValue() != null && ((String)theCriteriaLeaf.getKey()).equals(aKey) && aPartitions.contains(theCriteriaLeaf.getValue())) {
            return null;
        }
        return aCriteria;
    }
}

