/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import org.refcodes.data.Delimiter;
import org.refcodes.data.EnvironmentProperty;
import org.refcodes.data.Protocol;
import org.refcodes.data.SystemProperty;

public enum Proxy {
    HTTP(EnvironmentProperty.HTTP_PROXY, SystemProperty.HTTP_PROXY_HOST, SystemProperty.HTTP_PROXY_PORT, Protocol.HTTP),
    HTTPS(EnvironmentProperty.HTTPS_PROXY, SystemProperty.HTTPS_PROXY_HOST, SystemProperty.HTTPS_PROXY_PORT, Protocol.HTTPS),
    SOCKS(EnvironmentProperty.HTTP_PROXY, SystemProperty.SOCKS_PROXY_HOST, SystemProperty.SOCKS_PROXY_PORT, Protocol.SOCKS),
    SOCKS4(EnvironmentProperty.HTTP_PROXY, SystemProperty.SOCKS_PROXY_HOST, SystemProperty.SOCKS_PROXY_PORT, Protocol.SOCKS4),
    SOCKS5(EnvironmentProperty.HTTP_PROXY, SystemProperty.SOCKS_PROXY_HOST, SystemProperty.SOCKS_PROXY_PORT, Protocol.SOCKS5);

    private EnvironmentProperty _envProxy;
    private SystemProperty _sysHost;
    private SystemProperty _sysPort;
    private Protocol _protocol;

    private Proxy(EnvironmentProperty aEnvProxy, SystemProperty aSysHost, SystemProperty aSysPort, Protocol aProtocol) {
        this._envProxy = aEnvProxy;
        this._protocol = aProtocol;
        this._sysHost = aSysHost;
        this._sysPort = aSysPort;
    }

    public void initialize() {
        Proxy.toProxySettings(this._envProxy, this._sysHost, this._sysPort, this._protocol);
    }

    public static void initializeAll() {
        for (Proxy eProxy : Proxy.values()) {
            eProxy.initialize();
        }
    }

    protected static void toProxySettings(EnvironmentProperty aFromEnvProxy, SystemProperty aToSysHost, SystemProperty aToSysPort, Protocol aProtocol) {
        String theHttpProxy;
        if ((aToSysHost.getValue() == null || aToSysHost.getValue().length() == 0) && (theHttpProxy = aFromEnvProxy.getValue()) != null && theHttpProxy.toLowerCase().startsWith(aProtocol.getResourceLocatorPrefix().toLowerCase())) {
            int index = theHttpProxy.lastIndexOf(Delimiter.PORT.getChar());
            if (index != -1) {
                try {
                    int ePort = Integer.valueOf(theHttpProxy.substring(index + 1));
                    String eHost = theHttpProxy.substring(0, index);
                    aToSysHost.setValue(eHost);
                    aToSysPort.setValue(ePort + "");
                }
                catch (Exception e) {
                    aToSysHost.setValue(theHttpProxy);
                }
            } else {
                aToSysHost.setValue(theHttpProxy);
            }
        }
    }
}

