/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.Map;
import org.refcodes.logger.Logger;
import org.refcodes.logger.LoggerFactory;
import org.refcodes.logger.LoggerUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

abstract class AbstractCompositeLoggerFactory<L extends Logger<?>>
implements LoggerFactory<L> {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private int _numEndpoints;
    private LoggerFactory<L> _loggerFactory;

    public AbstractCompositeLoggerFactory(LoggerFactory<L> aLoggerFactory, int aNumEndpoints) {
        if (aNumEndpoints <= 0) {
            throw new IllegalArgumentException("The argument \"aNumEndpoints\" must be > 0, you proided a value of <" + this._numEndpoints + ">!");
        }
        this._numEndpoints = aNumEndpoints;
        this._loggerFactory = aLoggerFactory;
        LOGGER.debug("Got a Logger factory of type \"" + (aLoggerFactory != null ? aLoggerFactory.getClass().getName() : null) + "\".");
    }

    @Override
    public L createInstance(String aSchemaBody) {
        Logger[] theLoggers = new Logger[this.getNumEndpoints()];
        for (int i = 0; i < theLoggers.length; ++i) {
            String eSchemaName = LoggerUtility.getSchemaName(aSchemaBody, i);
            LOGGER.debug("Creating Logger <" + i + "> instance for schema \"" + eSchemaName + "\"...");
            theLoggers[i] = (Logger)this.getLoggerFactory().createInstance(eSchemaName);
        }
        return (L)this.createCompositeLogger(theLoggers);
    }

    @Override
    public L createInstance(String aSchemaBody, Map<String, String> aProperties) {
        Logger[] theLoggers = new Logger[this.getNumEndpoints()];
        for (int i = 0; i < theLoggers.length; ++i) {
            String eSchemaName = LoggerUtility.getSchemaName(aSchemaBody, i);
            LOGGER.debug("Creating Logger <" + i + "> instance for schema \"" + eSchemaName + "\"...");
            theLoggers[i] = (Logger)this.getLoggerFactory().createInstance(eSchemaName, aProperties);
        }
        return (L)this.createCompositeLogger(theLoggers);
    }

    protected abstract L createCompositeLogger(L[] var1);

    protected int getNumEndpoints() {
        return this._numEndpoints;
    }

    protected LoggerFactory<L> getLoggerFactory() {
        return this._loggerFactory;
    }
}

