/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.refcodes.data.Field;
import org.refcodes.logger.LogPriorityColumnImpl;
import org.refcodes.logger.MethodNameColumnImpl;
import org.refcodes.mixin.KeyAccessor;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnAccessor;
import org.refcodes.tabular.DateColumnImpl;
import org.refcodes.tabular.ExceptionColumnImpl;
import org.refcodes.tabular.IntegerColumnImpl;
import org.refcodes.tabular.PrintStackTrace;
import org.refcodes.tabular.StringColumnImpl;

public enum LoggerField implements ColumnAccessor,
KeyAccessor<String>,
TypeAccessor
{
    LOG_LINE_NUMBER(new IntegerColumnImpl(Field.LOG_LINE_NUMBER.getName())),
    LOG_PRIORITY(new LogPriorityColumnImpl(Field.LOG_PRIORITY.getName())),
    LOG_DATE(new DateColumnImpl(Field.LOG_DATE.getName())),
    LOG_THREAD_NAME(new StringColumnImpl(Field.LOG_THREAD_NAME.getName())),
    LOG_SESSION_ID(new StringColumnImpl(Field.LOG_SESSION_ID.getName())),
    LOG_REQUEST_ID(new StringColumnImpl(Field.LOG_REQUEST_ID.getName())),
    LOG_MESSAGE(new StringColumnImpl(Field.LOG_MESSAGE.getName())),
    LOG_NONE_STACKTRRACE_EXCEPTION(new ExceptionColumnImpl(Field.LOG_EXCEPTION.getName(), PrintStackTrace.NONE)),
    LOG_COMPACT_STACKTRACE_EXCEPTION(new ExceptionColumnImpl(Field.LOG_EXCEPTION.getName(), PrintStackTrace.COMPACT)),
    LOG_EXPLODED_STACKTRACE_EXCEPTION(new ExceptionColumnImpl(Field.LOG_EXCEPTION.getName(), PrintStackTrace.EXPLODED)),
    LOG_FULLY_QUALIFIED_CLASS_NAME(new StringColumnImpl(Field.LOG_FULLY_QUALIFIED_CLASS_NAME.getName())),
    LOG_METHODE_NAME(new MethodNameColumnImpl(Field.LOG_METHOD_NAME.getName())),
    LOG_CLASS_LINE_NUMBER(new IntegerColumnImpl(Field.LOG_CLASS_LINE_NUMBER.getName()));

    private Column<?> _column;

    private LoggerField(Column<?> aColumn) {
        this._column = aColumn;
    }

    public Column<?> getColumn() {
        return this._column;
    }

    @Override
    public String getKey() {
        return (String)this._column.getKey();
    }

    public Class<?> getType() {
        return this._column.getType();
    }

    public static LoggerField toExceptionLoggerField(PrintStackTrace aPrintStackTrace) {
        switch (aPrintStackTrace) {
            case COMPACT: {
                return LOG_COMPACT_STACKTRACE_EXCEPTION;
            }
            case NONE: {
                return LOG_NONE_STACKTRRACE_EXCEPTION;
            }
        }
        return LOG_EXPLODED_STACKTRACE_EXCEPTION;
    }

    public static Column<?> fromKey(String aKey) {
        List<LoggerField> theList = Arrays.asList(LoggerField.values());
        Iterator<LoggerField> e = theList.iterator();
        LoggerField eDefinition = null;
        while (e.hasNext()) {
            eDefinition = e.next();
            if (!((String)eDefinition.getColumn().getKey()).equalsIgnoreCase(aKey)) continue;
            return eDefinition.getColumn();
        }
        return null;
    }
}

