/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.InvocationStrategy;
import org.refcodes.criteria.Criteria;
import org.refcodes.exception.ExceptionAccessor;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.logger.LoggerAccessor;
import org.refcodes.logger.QueryLogger;
import org.refcodes.logger.TrimLogger;
import org.refcodes.tabular.CompositeRecordsImpl;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.Records;
import org.refcodes.tabular.RecordsAccessor;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextBuilderImpl;
import org.refcodes.textual.HorizAlignTextMode;

public final class LoggerUtility {
    private LoggerUtility() {
    }

    public static String getSchemaName(String aSchemaBody, int aIndex) {
        String eSchemaName = aSchemaBody + "." + ((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.LEFT).withText(new String[]{"" + aIndex})).withColumnWidth(4)).withFillChar('0').toString();
        return eSchemaName;
    }

    public static String getSchemaName(String aSchemaPrefix, String aSchemaSuffix) {
        String theSeparator = aSchemaPrefix != null && aSchemaPrefix.length() > 0 && aSchemaSuffix != null && aSchemaSuffix.length() > 0 ? "." : "";
        String theSchemaName = (aSchemaPrefix != null ? aSchemaPrefix : "") + theSeparator + (aSchemaSuffix != null ? aSchemaSuffix : "");
        if (theSchemaName.length() == 0) {
            throw new IllegalArgumentException("The schema prefix \"" + aSchemaPrefix + "\" and the schema suffix + \"" + aSchemaSuffix + "\" cannot be used to create a valid schema name, created schema name is empty!");
        }
        return theSchemaName;
    }

    public static <L extends QueryLogger<T>, T> Records<T> findLogs(Criteria aCriteria, Header<T> aHeader, int aLimit, Collection<L> aLoggers, InvocationStrategy aRecordServeStrategy) {
        if (aLoggers.size() == 1) {
            QueryLogger theLogger = (QueryLogger)aLoggers.iterator().next();
            return theLogger.findLogs(aCriteria, aHeader, aLimit);
        }
        ArrayList<FindLogsDaemon<QueryLogger, T>> theThreads = new ArrayList<FindLogsDaemon<QueryLogger, T>>();
        FindLogsDaemon<QueryLogger, T> eThread = null;
        for (QueryLogger eLogger : aLoggers) {
            eThread = new FindLogsDaemon<QueryLogger, T>(eLogger, aCriteria, aHeader, aLimit);
            eThread.setPriority(5);
            eThread.setDaemon(true);
            eThread.start();
            theThreads.add(eThread);
        }
        ControlFlowUtility.joinThreads(theThreads);
        Throwable theException = ExceptionUtility.toException(theThreads);
        if (theException != null) {
            throw new HiddenException(theException);
        }
        List theRecords = LoggerUtility.getRecords(theThreads);
        return new CompositeRecordsImpl(aRecordServeStrategy, theRecords);
    }

    public static <L extends TrimLogger<T>, T> void deleteLogs(Criteria aCriteria, Collection<L> aLoggers) {
        if (aLoggers.size() == 1) {
            TrimLogger theLogger = (TrimLogger)aLoggers.iterator().next();
            theLogger.deleteLogs(aCriteria);
            return;
        }
        ArrayList theThreads = new ArrayList();
        DeleteLogsDaemon eThread = null;
        for (TrimLogger trimLogger : aLoggers) {
            eThread = new DeleteLogsDaemon(trimLogger, aCriteria);
            eThread.setPriority(5);
            eThread.setDaemon(true);
            eThread.start();
            theThreads.add(eThread);
        }
        for (Thread thread : theThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        Throwable theException = ExceptionUtility.toException(theThreads);
        if (theException != null) {
            throw new HiddenException(theException);
        }
    }

    public static <L extends TrimLogger<T>, T> void clearLogs(Collection<L> aLoggers) {
        ArrayList theThreads = new ArrayList();
        ClearLogsDaemon eThread = null;
        for (TrimLogger trimLogger : aLoggers) {
            eThread = new ClearLogsDaemon(trimLogger);
            eThread.setPriority(5);
            eThread.setDaemon(true);
            eThread.start();
            theThreads.add(eThread);
        }
        for (Thread thread : theThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        Throwable theException = ExceptionUtility.toException(theThreads);
        if (theException != null) {
            throw new HiddenException(theException);
        }
    }

    private static List<Records<?>> getRecords(List<?> aRecordPropertyList) {
        ArrayList theRecords = new ArrayList();
        RecordsAccessor eRecordsProperty = null;
        for (Object eObj : aRecordPropertyList) {
            if (!(eObj instanceof RecordsAccessor)) continue;
            eRecordsProperty = (RecordsAccessor)eObj;
            theRecords.add(eRecordsProperty.getRecords());
        }
        return theRecords;
    }

    private static class ClearLogsDaemon<L extends TrimLogger<T>, T>
    extends Thread
    implements ExceptionAccessor<Exception>,
    LoggerAccessor<L> {
        private L _logger;
        private Exception _exception = null;

        public ClearLogsDaemon(L aLogger) {
            this._logger = aLogger;
            this.setDaemon(true);
            this.setPriority(5);
        }

        @Override
        public L getLogger() {
            return this._logger;
        }

        @Override
        public Exception getException() {
            return this._exception;
        }

        @Override
        public void run() {
            try {
                this._logger.clear();
            }
            catch (Exception e) {
                this._exception = e;
            }
        }
    }

    private static class DeleteLogsDaemon<L extends TrimLogger<T>, T>
    extends Thread
    implements ExceptionAccessor<Exception>,
    LoggerAccessor<L> {
        private L _logger;
        private Criteria _criteria = null;
        private Exception _exception = null;

        public DeleteLogsDaemon(L aLogger, Criteria aCriteria) {
            this._logger = aLogger;
            this._criteria = aCriteria;
            this.setDaemon(true);
            this.setPriority(5);
        }

        @Override
        public L getLogger() {
            return this._logger;
        }

        @Override
        public Exception getException() {
            return this._exception;
        }

        @Override
        public void run() {
            try {
                this._logger.deleteLogs(this._criteria);
            }
            catch (Exception e) {
                this._exception = e;
            }
        }
    }

    private static class FindLogsDaemon<L extends QueryLogger<T>, T>
    extends Thread
    implements ExceptionAccessor<Exception>,
    LoggerAccessor<L>,
    RecordsAccessor<T> {
        private L _logger;
        private Criteria _criteria = null;
        private Header<T> _columns = null;
        private Records<T> _records = null;
        private Exception _exception = null;
        private int _limit = -1;

        public FindLogsDaemon(L aLogger, Criteria aCriteria, Header<T> aHeader, int aLimit) {
            this._logger = aLogger;
            this._criteria = aCriteria;
            this._columns = aHeader;
            this._limit = aLimit;
            this.setDaemon(true);
            this.setPriority(5);
        }

        @Override
        public L getLogger() {
            return this._logger;
        }

        @Override
        public Records<T> getRecords() {
            return this._records;
        }

        @Override
        public Exception getException() {
            return this._exception;
        }

        @Override
        public void run() {
            try {
                this._records = this._logger.findLogs(this._criteria, this._columns, this._limit);
            }
            catch (Exception e) {
                this._exception = e;
            }
        }
    }
}

