/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.beanutils.BeanHelper;
import org.apache.commons.configuration.beanutils.XMLBeanDeclaration;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.logger.LoggerInstantiationRuntimeException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class RuntimeLoggerUtility {
    public static RuntimeLogger fromConfigurationFile(String aElementPath, String aConfigFileName) throws LoggerInstantiationRuntimeException {
        if (aConfigFileName == null) {
            throw new IllegalArgumentException("The configuration file name must not be null.");
        }
        if (aElementPath == null) {
            throw new IllegalArgumentException("The element path referencing your logger in the configuration file \"" + aConfigFileName + "\" must not be null.");
        }
        List<File> theAppConfigDirs = null;
        try {
            theAppConfigDirs = RuntimeUtility.toConfigDirs();
            for (File eDir : theAppConfigDirs) {
                File eFile = new File(eDir, aConfigFileName);
                if (!eFile.exists() || !eFile.isFile() || !eFile.canRead()) continue;
                XMLConfiguration config = new XMLConfiguration(eFile);
                XMLBeanDeclaration theDeclaration = new XMLBeanDeclaration(config, aElementPath);
                return (RuntimeLogger)BeanHelper.createBean(theDeclaration);
            }
            XMLConfiguration config = new XMLConfiguration(aConfigFileName);
            XMLBeanDeclaration theDeclaration = new XMLBeanDeclaration(config, aElementPath);
            return (RuntimeLogger)BeanHelper.createBean(theDeclaration);
        }
        catch (IOException | ClassCastException | IllegalArgumentException | ConfigurationException | ConfigurationRuntimeException e) {
            throw new LoggerInstantiationRuntimeException("Unable to instantiate the runtime logger singleton (check your configuration file \"" + aConfigFileName + "\" and the configuration locations " + new VerboseTextBuilderImpl().withElements(theAppConfigDirs).toString() + "): " + ExceptionUtility.toMessage(e), e);
        }
    }
}

