/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.console;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.jansi.AnsiConsole;
import org.refcodes.component.Destroyable;
import org.refcodes.data.Text;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.UnexpectedLogRuntimeException;
import org.refcodes.logger.alt.console.FormattedLogger;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.FormattedColumn;
import org.refcodes.tabular.FormattedHeader;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.Row;
import org.refcodes.textual.ColumnSetupMetrics;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableBuilderImpl;
import org.refcodes.textual.TableStyle;

public class FormattedLoggerImpl<T>
implements Destroyable,
FormattedLogger<T> {
    protected FormattedHeader<T> _header;
    protected TableBuilder _tableBuilder;
    protected PrintStream _stdStream = Shell.toShell() == Shell.WIN_CMD ? AnsiConsole.out : System.out;
    protected PrintStream _errStream = Shell.toShell() == Shell.WIN_CMD ? AnsiConsole.err : System.err;
    protected int _rowWidth = SystemUtility.toConsoleWidth();
    protected TableStyle _tableStyle;
    protected boolean _hasLeftBorder = false;
    protected boolean _hasRightBorder = false;
    private List<String> _columnNames;
    private boolean _isEscCodesEnabled = SystemUtility.toAnsiConsole();

    public FormattedLoggerImpl(FormattedHeader<T> aHeader) {
        this._header = aHeader;
        this._tableStyle = OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS ? TableStyle.ASCII : TableStyle.SINGLE;
        this.init();
    }

    @Override
    public synchronized void log(Record<? extends T> aRecord) throws IllegalRecordRuntimeException, UnexpectedLogRuntimeException {
        this.log(aRecord, this._header, this._tableBuilder);
    }

    @Override
    public PrintStream getStandardPrintStream() {
        return this._stdStream;
    }

    @Override
    public void setStandardPrintStream(PrintStream aOutStream) {
        this._stdStream = aOutStream;
    }

    @Override
    public PrintStream getErrorPrintStream() {
        return this._errStream;
    }

    @Override
    public void setErrorPrintStream(PrintStream aErrStream) {
        this._errStream = aErrStream;
    }

    @Override
    public TableStyle getTableStyle() {
        return this._tableStyle;
    }

    @Override
    public void setTableStyle(TableStyle aTableStyle) {
        this._tableStyle = aTableStyle;
        this.init();
    }

    @Override
    public void setLoggerStyle(String aTableStyleName) {
        this.setTableStyle(TableStyle.valueOf(aTableStyleName));
    }

    @Override
    public void setEscapeCodes(boolean isEscCodesEnabled) {
        this._isEscCodesEnabled = isEscCodesEnabled;
        TableBuilder theTableBuilder = this._tableBuilder;
        if (theTableBuilder != null) {
            theTableBuilder.withEscapeCodes(isEscCodesEnabled);
        }
    }

    @Override
    public boolean hasLeftBorder() {
        return this._hasLeftBorder;
    }

    @Override
    public void setLeftBorder(boolean hasLeftBorder) {
        this._hasLeftBorder = hasLeftBorder;
        this.init();
    }

    @Override
    public boolean hasRightBorder() {
        return this._hasRightBorder;
    }

    @Override
    public void setRightBorder(boolean hasRightBorder) {
        this._hasRightBorder = hasRightBorder;
        this.init();
    }

    @Override
    public int getRowWidth() {
        return this._rowWidth;
    }

    @Override
    public void setRowWidth(int aRowWidth) {
        this._rowWidth = aRowWidth;
        this.init();
    }

    @Override
    public boolean hasEscapeCodes() {
        return this._isEscCodesEnabled;
    }

    @Override
    public void destroy() {
        if (Shell.toShell() == Shell.WIN_CMD) {
            AnsiConsole.systemUninstall();
        }
        this._tableBuilder.printTail();
    }

    protected void init() {
        TableBuilder theTableBuilder;
        block3: {
            if (Shell.toShell() == Shell.WIN_CMD) {
                AnsiConsole.systemInstall();
            }
            theTableBuilder = this.toPreConfiguredTableBuilder(this._header, OutputPrintStream.STANDARD);
            this._columnNames = new ArrayList<String>();
            for (ColumnSetupMetrics columnSetupMetrics : this._header) {
                if (!columnSetupMetrics.isVisible()) continue;
                this._columnNames.add(columnSetupMetrics.getName());
            }
            for (String string : this._columnNames) {
                if (string == null || string.length() == 0) continue;
                break block3;
            }
            this._columnNames.clear();
            this._columnNames = null;
        }
        this._tableBuilder = theTableBuilder;
    }

    protected TableBuilder toPreConfiguredTableBuilder(FormattedHeader<?> aHeader, OutputPrintStream aOutputPrintStream) {
        TableBuilder theTableBuilder = new TableBuilderImpl(this._rowWidth).withTableStyle(this._tableStyle).withPrintStream(aOutputPrintStream == OutputPrintStream.STANDARD ? this._stdStream : this._errStream).withResetEscapeCode(this._header.getResetEscapeCode()).withLeftBorder(this._hasLeftBorder).withRightBorder(this._hasRightBorder).withEscapeCodes(this._isEscCodesEnabled).withLineBreak(SystemUtility.toLineBreak(this._rowWidth));
        for (ColumnSetupMetrics columnSetupMetrics : aHeader) {
            if (!columnSetupMetrics.isVisible()) continue;
            theTableBuilder.addColumn().withColumnFormatMetrics(columnSetupMetrics);
        }
        return theTableBuilder;
    }

    protected void log(Record<? extends T> aRecord, FormattedHeader<T> aHeader, TableBuilder aTableBuilder) {
        if (this._columnNames != null) {
            this._tableBuilder.printHeaderBegin();
            this._tableBuilder.printHeaderContinue(this._columnNames);
            this._tableBuilder.printHeaderComplete();
            this._columnNames.clear();
            this._columnNames = null;
        }
        try {
            int i;
            Row<String> theRow = aHeader.toPrintableRow(aRecord);
            for (i = aHeader.size() - 1; i >= 0; --i) {
                if (((FormattedColumn)aHeader.get(i)).isVisible() || theRow.size() <= i) continue;
                theRow.remove(i);
            }
            for (i = 0; i < theRow.size(); ++i) {
                if (theRow.get(i) != null) continue;
                theRow.remove(i);
                theRow.add(i, Text.NULL_VALUE.getText());
            }
            aTableBuilder.printRowContinue(theRow);
        }
        catch (ClassCastException | ColumnMismatchException | HeaderMismatchException e) {
            throw new IllegalRecordRuntimeException(aRecord, (Throwable)e);
        }
    }

    public static enum OutputPrintStream {
        STANDARD,
        ERROR;

    }
}

