/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.numerical.BitwiseOperationBuilder;

public class BitwiseOperationBuilderImpl
implements BitwiseOperationBuilder {
    private Integer _value = 0;

    @Override
    public Integer getValue() {
        return this._value;
    }

    @Override
    public void setValue(Integer aValue) {
        this._value = aValue;
    }

    @Override
    public BitwiseOperationBuilder withAnd(Integer aOperand) {
        this._value = BitwiseOperationBuilderImpl.toBitwiseAND(this._value, aOperand);
        return this;
    }

    @Override
    public BitwiseOperationBuilder withOr(Integer aOperand) {
        this._value = BitwiseOperationBuilderImpl.toBitwiseOR(this._value, aOperand);
        return this;
    }

    @Override
    public BitwiseOperationBuilder withXor(Integer aOperand) {
        this._value = BitwiseOperationBuilderImpl.toBitwiseXOR(this._value, aOperand);
        return this;
    }

    @Override
    public BitwiseOperationBuilder withNot() {
        this._value = BitwiseOperationBuilderImpl.toBitwiseNOT(this._value);
        return this;
    }

    @Override
    public boolean isMaskable(Integer aMask) {
        return BitwiseOperationBuilderImpl.isBitwiseMaskable(this._value, aMask);
    }

    @Override
    public boolean isTrueAt(int aPosition) {
        return BitwiseOperationBuilderImpl.isTrueAt(this._value, aPosition);
    }

    protected static int toBitwiseAND(int aValueA, int aValueB) {
        String result = "";
        String[] bitStrings = BitwiseOperationBuilderImpl.getBitStrings(aValueA, aValueB);
        for (int i = 0; i < bitStrings[0].length(); ++i) {
            result = bitStrings[0].charAt(i) == '1' && bitStrings[1].charAt(i) == '1' ? result + "1" : result + "0";
        }
        return Integer.parseInt(result, 2);
    }

    protected static int toBitwiseNOT(int aValue) {
        String result = "";
        String bitString = Integer.toBinaryString(aValue);
        int strLenght = bitString.length();
        for (int i = 0; i < strLenght; ++i) {
            result = bitString.charAt(i) == '1' ? result + "0" : result + "1";
        }
        return Integer.parseInt(result, 2);
    }

    protected static int toBitwiseOR(int aValueA, int aValueB) {
        String result = "";
        String[] bitStrings = BitwiseOperationBuilderImpl.getBitStrings(aValueA, aValueB);
        for (int i = 0; i < bitStrings[0].length(); ++i) {
            result = bitStrings[0].charAt(i) == '1' || bitStrings[1].charAt(i) == '1' ? result + "1" : result + "0";
        }
        return Integer.parseInt(result, 2);
    }

    protected static int toBitwiseXOR(int aValueA, int aValueB) {
        String result = "";
        String[] bitStrings = BitwiseOperationBuilderImpl.getBitStrings(aValueA, aValueB);
        for (int i = 0; i < bitStrings[0].length(); ++i) {
            result = bitStrings[0].charAt(i) == '1' ^ bitStrings[1].charAt(i) == '1' ? result + "1" : result + "0";
        }
        return Integer.parseInt(result, 2);
    }

    protected static boolean isBitwiseMaskable(int aValue, int aMask) {
        String[] bitStrings = BitwiseOperationBuilderImpl.getBitStrings(aValue, aMask);
        for (int i = 0; i < bitStrings[0].length(); ++i) {
            if (bitStrings[1].charAt(i) != '1' || bitStrings[0].charAt(i) != '0') continue;
            return false;
        }
        return true;
    }

    protected static boolean isTrueAt(int aValue, int aPos) {
        String bitString = Integer.toBinaryString(aValue);
        int bitStringLength = bitString.length();
        if (aPos < 0 || aPos > bitStringLength - 1) {
            return false;
        }
        return bitString.charAt(bitStringLength - 1 - aPos) == '1';
    }

    private static String[] getBitStrings(int aValueA, int aValueB) {
        String theBitStringB;
        String theBitStringA;
        block3: {
            block2: {
                theBitStringA = Integer.toBinaryString(aValueA);
                theBitStringB = Integer.toBinaryString(aValueB);
                if (theBitStringA.length() <= theBitStringB.length()) break block2;
                while (theBitStringB.length() < theBitStringA.length()) {
                    theBitStringB = "0" + theBitStringB;
                }
                break block3;
            }
            if (theBitStringA.length() >= theBitStringB.length()) break block3;
            while (theBitStringA.length() < theBitStringB.length()) {
                theBitStringA = "0" + theBitStringA;
            }
        }
        return new String[]{theBitStringA, theBitStringB};
    }
}

