/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer;

import org.refcodes.matcher.Matcher;
import org.refcodes.matcher.MatcherSugar;
import org.refcodes.observer.EventMatcher;
import org.refcodes.observer.EventMetaData;
import org.refcodes.observer.MetaDataActionEvent;
import org.refcodes.observer.MetaDataEvent;

public class EventMatcherSugar {
    public static <E extends MetaDataEvent<?>> EventMatcher<E> isAssignableFrom(Class<?> aEventType) {
        Matcher theAssignableFrom = MatcherSugar.isAssignableFrom(aEventType);
        return new EventMatcherWrapper(theAssignableFrom);
    }

    public static <E extends MetaDataEvent<?>, PT> EventMatcher<E> publisherIsAssignableFrom(Class<? extends PT> aPublisherType) {
        return new PublisherIsAssignableFromMatcherImpl(aPublisherType);
    }

    @SafeVarargs
    public static <E extends MetaDataEvent<?>> EventMatcher<E> or(EventMatcher<E> ... aEventMatchers) {
        return new EventMatcherWrapper<E>(MatcherSugar.or(aEventMatchers));
    }

    @SafeVarargs
    public static <E extends MetaDataEvent<?>> EventMatcher<E> and(EventMatcher<E> ... aEventMatchers) {
        return new EventMatcherWrapper<E>(MatcherSugar.and(aEventMatchers));
    }

    public static <E extends MetaDataEvent<?>> EventMatcher<E> nameEqualWith(String aName) {
        return new NameEqualWithMatcherImpl(aName);
    }

    public static <E extends MetaDataEvent<?>> EventMatcher<E> groupEqualWith(String aGroup) {
        return new GroupEqualWithMatcherImpl(aGroup);
    }

    public static <E extends MetaDataEvent<?>> EventMatcher<E> universalIdEqualWith(String aUniversalId) {
        return new UniversalIdEqualWithMatcherImpl(aUniversalId);
    }

    public static <E extends MetaDataActionEvent<A, ?>, A> EventMatcher<E> actionEqualWith(A aAction) {
        return new ActionEqualWithMatcherImpl(aAction);
    }

    private static class ActionEqualWithMatcherImpl<E extends MetaDataActionEvent<?, ?>>
    implements EventMatcher<E> {
        private Object _action;

        public <A> ActionEqualWithMatcherImpl(A aAction) {
            this._action = aAction;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            if (this._action != null) {
                return this._action.equals(aEvent.getAction());
            }
            return aEvent.getAction() == null;
        }
    }

    private static class UniversalIdEqualWithMatcherImpl<E extends MetaDataEvent<?>>
    implements EventMatcher<E> {
        private String _universalId;

        public UniversalIdEqualWithMatcherImpl(String aUniversalId) {
            this._universalId = aUniversalId;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            if (this._universalId != null) {
                return this._universalId.equals(((EventMetaData)aEvent.getMetaData()).getUniversalId());
            }
            return ((EventMetaData)aEvent.getMetaData()).getUniversalId() == null;
        }
    }

    private static class GroupEqualWithMatcherImpl<E extends MetaDataEvent<?>>
    implements EventMatcher<E> {
        private String _group;

        public GroupEqualWithMatcherImpl(String aGroup) {
            this._group = aGroup;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            if (this._group != null) {
                return this._group.equals(((EventMetaData)aEvent.getMetaData()).getGroup());
            }
            return ((EventMetaData)aEvent.getMetaData()).getGroup() == null;
        }
    }

    private static class NameEqualWithMatcherImpl<E extends MetaDataEvent<?>>
    implements EventMatcher<E> {
        private String _name;

        public NameEqualWithMatcherImpl(String aName) {
            this._name = aName;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            if (this._name != null) {
                return this._name.equals(((EventMetaData)aEvent.getMetaData()).getName());
            }
            return ((EventMetaData)aEvent.getMetaData()).getName() == null;
        }
    }

    private static class PublisherIsAssignableFromMatcherImpl<E extends MetaDataEvent<?>, PT>
    implements EventMatcher<E> {
        private Class<? extends PT> _eventPublisherType;

        public PublisherIsAssignableFromMatcherImpl(Class<? extends PT> aEventPublisherType) {
            this._eventPublisherType = aEventPublisherType;
        }

        @Override
        public boolean isMatching(E aEvent) {
            assert (aEvent != null);
            return this._eventPublisherType == null || ((EventMetaData)aEvent.getMetaData()).getPublisherType().isAssignableFrom(this._eventPublisherType);
        }
    }

    private static class EventMatcherWrapper<E extends MetaDataEvent<?>>
    implements EventMatcher<E> {
        private Matcher<E> _eventMatcher;

        public EventMatcherWrapper(Matcher<E> aMatcher) {
            assert (aMatcher != null);
            this._eventMatcher = aMatcher;
        }

        @Override
        public boolean isMatching(E aEvent) {
            return this._eventMatcher.isMatching(aEvent);
        }
    }
}

