/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.util.Collection;
import org.refcodes.component.ComponentUtility;
import org.refcodes.component.CompositeComponent;
import org.refcodes.component.InitializeException;
import org.refcodes.component.OpenException;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.controlflow.InvocationStrategy;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.Records;

public class CompositeRecordsImpl<T>
implements Records<T>,
CompositeComponent {
    private InvocationStrategy _recordServeStrategy;
    private ExecutionStrategy _componentExecutionStrategy;
    private Records<T>[] _records;
    private int _recordsIndex = 0;
    boolean _hasInitialNext = false;

    @SafeVarargs
    public CompositeRecordsImpl(InvocationStrategy aRecordServeStrategy, Records<T> ... aRecords) {
        this(ExecutionStrategy.JOIN, aRecordServeStrategy, aRecords);
    }

    @SafeVarargs
    public CompositeRecordsImpl(ExecutionStrategy aComponentExecutionStrategy, InvocationStrategy aRecordServeStrategy, Records<T> ... aRecords) {
        this._recordServeStrategy = aRecordServeStrategy;
        this._records = aRecords;
        if (this._recordServeStrategy.equals((Object)InvocationStrategy.ROUND_ROBIN)) {
            this._recordsIndex = 0;
        } else if (this._recordServeStrategy.equals((Object)InvocationStrategy.FIRST_TO_LAST)) {
            this._recordsIndex = 0;
        } else if (this._recordServeStrategy.equals((Object)InvocationStrategy.LAST_TO_FIRST)) {
            this._recordsIndex = aRecords.length - 1;
        }
        this._componentExecutionStrategy = aComponentExecutionStrategy;
    }

    public CompositeRecordsImpl(InvocationStrategy aRecordServeStrategy, Collection<Records<T>> aRecords) {
        this(ExecutionStrategy.JOIN, aRecordServeStrategy, aRecords);
    }

    public CompositeRecordsImpl(ExecutionStrategy aComponentExecutionStrategy, InvocationStrategy aRecordServeStrategy, Collection<Records<T>> aRecords) {
        this(aComponentExecutionStrategy, aRecordServeStrategy, aRecords.toArray(new Records[aRecords.size()]));
    }

    @Override
    public boolean hasNext() {
        for (Records<T> eRecords : this._records) {
            if (!eRecords.hasNext()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record<? extends T> next() {
        CompositeRecordsImpl compositeRecordsImpl = this;
        synchronized (compositeRecordsImpl) {
            this.doPrepareNext();
            Record theRecord = (Record)this._records[this._recordsIndex].next();
            this._hasInitialNext = true;
            return theRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        CompositeRecordsImpl compositeRecordsImpl = this;
        synchronized (compositeRecordsImpl) {
            if (!this._hasInitialNext) {
                throw new IllegalStateException("This method can only be called after at least initially calling the \"next()\" method once.");
            }
            this._records[this._recordsIndex].remove();
        }
    }

    private void doPrepareNext() {
        int theIndex = this._recordsIndex;
        block5: while (this.hasNext()) {
            switch (this._recordServeStrategy) {
                case ROUND_ROBIN: {
                    if (++theIndex >= this._records.length) {
                        theIndex = 0;
                    }
                    if (!this._records[theIndex].hasNext()) continue block5;
                    this._recordsIndex = theIndex;
                    return;
                }
                case FIRST_TO_LAST: {
                    if (this._records[theIndex].hasNext()) {
                        this._recordsIndex = theIndex;
                        return;
                    }
                    if (theIndex == this._records.length - 1) {
                        return;
                    }
                    ++theIndex;
                    continue block5;
                }
                case LAST_TO_FIRST: {
                    if (this._records[theIndex].hasNext()) {
                        this._recordsIndex = theIndex;
                        return;
                    }
                    if (theIndex == 0) {
                        return;
                    }
                    --theIndex;
                    continue block5;
                }
            }
        }
    }

    @Override
    public void initialize() throws InitializeException {
        ComponentUtility.initialize(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void start() throws StartException {
        ComponentUtility.start(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void pause() throws PauseException {
        ComponentUtility.pause(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void resume() throws ResumeException {
        ComponentUtility.resume(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void stop() throws StopException {
        ComponentUtility.stop(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void decompose() {
        ComponentUtility.decompose(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void flush() throws OpenException {
        ComponentUtility.flush(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void destroy() {
        ComponentUtility.destroy(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void reset() {
        ComponentUtility.reset(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void open() throws OpenException {
        ComponentUtility.open(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void close() {
        ComponentUtility.close(this._componentExecutionStrategy, this._records);
    }

    @Override
    public void dispose() {
        ComponentUtility.dispose(this._componentExecutionStrategy, this._records);
    }
}

