/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.refcodes.data.FileNameExtension;
import org.refcodes.tabular.ColumnFactory;
import org.refcodes.tabular.CsvInputStreamRecordsImpl;
import org.refcodes.tabular.Header;

public class CsvFileRecordsImpl<T>
extends CsvInputStreamRecordsImpl<T> {
    public CsvFileRecordsImpl(Header<T> aHeader, File aCsvFile) throws FileNotFoundException, IOException, ZipException {
        super(aHeader, CsvFileRecordsImpl.toInputStream(aCsvFile));
    }

    public CsvFileRecordsImpl(Header<T> aHeader, File aCsvFile, char aCsvSeparator) throws FileNotFoundException, IOException, ZipException {
        super(aHeader, CsvFileRecordsImpl.toInputStream(aCsvFile), aCsvSeparator);
    }

    public CsvFileRecordsImpl(Header<T> aHeader, File aCsvFile, boolean isStrict) throws FileNotFoundException, IOException, ZipException {
        super(aHeader, CsvFileRecordsImpl.toInputStream(aCsvFile), isStrict);
    }

    public CsvFileRecordsImpl(Header<T> aHeader, File aCsvFile, char aCsvSeparator, boolean isStrict) throws FileNotFoundException, IOException, ZipException {
        super(aHeader, CsvFileRecordsImpl.toInputStream(aCsvFile), aCsvSeparator, isStrict);
    }

    public CsvFileRecordsImpl(ColumnFactory<T> aColumnFactory, File aCsvFile) throws FileNotFoundException, IOException, ZipException {
        super(aColumnFactory, CsvFileRecordsImpl.toInputStream(aCsvFile));
    }

    public CsvFileRecordsImpl(ColumnFactory<T> aColumnFactory, File aCsvFile, char aCsvSeparator) throws FileNotFoundException, IOException, ZipException {
        super(aColumnFactory, CsvFileRecordsImpl.toInputStream(aCsvFile), aCsvSeparator);
    }

    public CsvFileRecordsImpl(ColumnFactory<T> aColumnFactory, File aCsvFile, boolean isStrict) throws FileNotFoundException, IOException, ZipException {
        super(aColumnFactory, CsvFileRecordsImpl.toInputStream(aCsvFile), isStrict);
    }

    public CsvFileRecordsImpl(ColumnFactory<T> aColumnFactory, File aCsvFile, char aCsvSeparator, boolean isStrict) throws FileNotFoundException, IOException, ZipException {
        super(aColumnFactory, CsvFileRecordsImpl.toInputStream(aCsvFile), aCsvSeparator, isStrict);
    }

    protected static InputStream toInputStream(File aFile) throws ZipException, IOException, FileNotFoundException {
        String theUnZipFileName = CsvFileRecordsImpl.toFileNameFromZip(aFile.getName());
        if (theUnZipFileName != null) {
            ZipFile theZipFile = new ZipFile(aFile);
            if (theZipFile.size() != 1) {
                throw new ZipException("The file \"" + aFile.getAbsolutePath() + "\" has <" + theZipFile.size() + "\" entries, expecting exactly one entry with name \"" + theUnZipFileName + "\"!");
            }
            Enumeration<? extends ZipEntry> e = theZipFile.entries();
            ZipEntry theEntry = e.nextElement();
            if (!theUnZipFileName.equals(theEntry.getName())) {
                throw new ZipException("The file \"" + aFile.getAbsolutePath() + "\" contains an entry with name \"" + theEntry.getName() + "\", though expecting entry with name \"" + theUnZipFileName + "\"!");
            }
            return new BufferedInputStream(theZipFile.getInputStream(theEntry));
        }
        return new BufferedInputStream(new FileInputStream(aFile));
    }

    protected static String toFileNameFromZip(String aZipFileName) {
        if (aZipFileName.toLowerCase().endsWith(FileNameExtension.ZIP.getExtension())) {
            return aZipFileName.substring(0, aZipFileName.length() - FileNameExtension.ZIP.getExtension().length());
        }
        return null;
    }
}

